/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class FacetPointersManager
extends AbstractProjectComponent {
    protected FacetPointersManager(Project project) {
        super(project);
    }

    public static FacetPointersManager getInstance(Project project) {
        return project.getComponent(FacetPointersManager.class);
    }

    public abstract <F extends Facet> FacetPointer<F> create(F var1);

    public abstract <F extends Facet> FacetPointer<F> create(String var1);

    public abstract void addListener(FacetPointerListener<Facet> var1);

    public abstract void addListener(FacetPointerListener<Facet> var1, Disposable var2);

    public abstract void removeListener(FacetPointerListener<Facet> var1);

    public abstract <F extends Facet> void addListener(Class<F> var1, FacetPointerListener<F> var2);

    public abstract <F extends Facet> void addListener(Class<F> var1, FacetPointerListener<F> var2, Disposable var3);

    public abstract <F extends Facet> void removeListener(Class<F> var1, FacetPointerListener<F> var2);

    public static String constructId(String moduleName, String facetTypeId, String facetName) {
        return moduleName + "/" + facetTypeId + "/" + facetName;
    }

    @NotNull
    public static String constructId(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/pointers/FacetPointersManager", "constructId"));
        }
        String string = FacetPointersManager.constructId(facet.getModule().getName(), facet.getType().getStringId(), facet.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/pointers/FacetPointersManager", "constructId"));
        }
        return string;
    }

    @NotNull
    public static String getFacetName(@NotNull String facetPointerId) {
        if (facetPointerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/pointers/FacetPointersManager", "getFacetName"));
        }
        String string = facetPointerId.substring(facetPointerId.lastIndexOf(47) + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/pointers/FacetPointersManager", "getFacetName"));
        }
        return string;
    }

    @NotNull
    public static String getModuleName(String facetPointerId) {
        String string = facetPointerId.substring(0, facetPointerId.indexOf(47));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/pointers/FacetPointersManager", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public static String getFacetType(@NotNull String facetPointerId) {
        if (facetPointerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/pointers/FacetPointersManager", "getFacetType"));
        }
        String string = facetPointerId.substring(facetPointerId.indexOf(47) + 1, facetPointerId.lastIndexOf(47));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/pointers/FacetPointersManager", "getFacetType"));
        }
        return string;
    }
}

