/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.facet.frameworks.beans.Artifacts;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesDownloadAssistant {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.LibrariesDownloadAssistant");

    private LibrariesDownloadAssistant() {
    }

    @NotNull
    public static Artifact[] getVersions(@NotNull String groupId, URL ... localUrls) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getVersions"));
        }
        if (localUrls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getVersions"));
        }
        Artifact[] versions = LibrariesDownloadAssistant.getDownloadServiceVersions(groupId);
        Artifact[] artifactArray = versions == null ? LibrariesDownloadAssistant.getVersions(localUrls) : versions;
        if (artifactArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getVersions"));
        }
        return artifactArray;
    }

    @Nullable
    private static Artifact[] getDownloadServiceVersions(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getDownloadServiceVersions"));
        }
        URL url = LibrariesDownloadAssistant.createVersionsUrl(id);
        if (url == null) {
            return null;
        }
        Artifacts allArtifacts = LibrariesDownloadAssistant.deserialize(url);
        return allArtifacts == null ? null : allArtifacts.getArtifacts();
    }

    @Nullable
    private static URL createVersionsUrl(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "createVersionsUrl"));
        }
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + id + "/";
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static Artifact[] getVersions(URL ... urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getVersions"));
        }
        HashSet versions = new HashSet();
        for (URL url : urls) {
            Artifact[] vers;
            Artifacts allArtifacts = LibrariesDownloadAssistant.deserialize(url);
            if (allArtifacts == null || (vers = allArtifacts.getArtifacts()) == null) continue;
            versions.addAll(Arrays.asList(vers));
        }
        Artifact[] artifactArray = versions.toArray(new Artifact[versions.size()]);
        if (artifactArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getVersions"));
        }
        return artifactArray;
    }

    @Nullable
    private static Artifacts deserialize(@Nullable URL url) {
        Artifacts allArtifacts;
        block3: {
            if (url == null) {
                return null;
            }
            allArtifacts = null;
            try {
                allArtifacts = (Artifacts)XmlSerializer.deserialize((URL)url, Artifacts.class);
            }
            catch (XmlSerializationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) break block3;
                LOG.error((Throwable)e);
            }
        }
        return allArtifacts;
    }

    @Nullable
    public static Artifact findVersion(@NotNull String versionId, URL ... urls) {
        if (versionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "findVersion"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "findVersion"));
        }
        return LibrariesDownloadAssistant.findVersion(LibrariesDownloadAssistant.getVersions(urls), versionId);
    }

    @Nullable
    private static Artifact findVersion(@Nullable Artifact[] versions, final @NotNull String versionId) {
        if (versionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "findVersion"));
        }
        return versions == null ? null : (Artifact)ContainerUtil.find((Object[])versions, (Condition)new Condition<Artifact>(){

            public boolean value(Artifact springVersion) {
                return versionId.equals(springVersion.getVersion());
            }
        });
    }

    @NotNull
    public static LibraryInfo[] getLibraryInfos(@NotNull URL url, @NotNull String versionId) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getLibraryInfos"));
        }
        if (versionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getLibraryInfos"));
        }
        Artifact version = LibrariesDownloadAssistant.findVersion(LibrariesDownloadAssistant.getVersions(url), versionId);
        LibraryInfo[] libraryInfoArray = version != null ? LibrariesDownloadAssistant.getLibraryInfos(version) : LibraryInfo.EMPTY_ARRAY;
        if (libraryInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getLibraryInfos"));
        }
        return libraryInfoArray;
    }

    @NotNull
    public static LibraryInfo[] getLibraryInfos(@Nullable Artifact version) {
        if (version == null) {
            if (LibraryInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getLibraryInfos"));
            }
            return LibraryInfo.EMPTY_ARRAY;
        }
        List<LibraryInfo> infos = LibrariesDownloadAssistant.convert(version.getUrlPrefix(), version.getItems());
        LibraryInfo[] libraryInfoArray = infos.toArray(new LibraryInfo[infos.size()]);
        if (libraryInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "getLibraryInfos"));
        }
        return libraryInfoArray;
    }

    @NotNull
    private static List<LibraryInfo> convert(final String urlPrefix, @NotNull ArtifactItem[] jars) {
        if (jars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "convert"));
        }
        List list = ContainerUtil.mapNotNull((Object[])jars, (Function)new Function<ArtifactItem, LibraryInfo>(){

            public LibraryInfo fun(ArtifactItem artifactItem) {
                String downloadUrl = artifactItem.getUrl();
                if (urlPrefix != null) {
                    if (downloadUrl == null) {
                        downloadUrl = artifactItem.getName();
                    }
                    if (!downloadUrl.startsWith("http://")) {
                        downloadUrl = urlPrefix + downloadUrl;
                    }
                }
                return new LibraryInfo(artifactItem.getName(), downloadUrl, downloadUrl, artifactItem.getMD5(), artifactItem.getRequiredClasses());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/LibrariesDownloadAssistant", "convert"));
        }
        return list;
    }
}

