/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.List;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class ListTableWithButtons<T>
extends Observable {
    private final List<T> myElements = ContainerUtil.newArrayList();
    private final JPanel myPanel;
    private final TableView myTableView = new TableView(this.createListModel());
    private boolean myIsEnabled = true;

    protected ListTableWithButtons() {
        this.myTableView.getTableViewModel().setSortable(false);
        this.myPanel = ToolbarDecorator.createDecorator(this.myTableView).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListTableWithButtons.this.myTableView.stopEditing();
                ListTableWithButtons.this.setModified();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListTableWithButtons.this.myElements.add(ListTableWithButtons.this.createElement());
                        ListTableWithButtons.this.myTableView.getTableViewModel().setItems(ListTableWithButtons.this.myElements);
                        ListTableWithButtons.this.myTableView.getComponent().editCellAt(ListTableWithButtons.this.myElements.size() - 1, 0);
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListTableWithButtons.this.myTableView.stopEditing();
                ListTableWithButtons.this.setModified();
                Object selected = ListTableWithButtons.this.getSelection();
                if (selected != null) {
                    int selectedIndex = ListTableWithButtons.this.myElements.indexOf(selected);
                    ListTableWithButtons.this.myElements.remove(selected);
                    ListTableWithButtons.this.myTableView.getTableViewModel().setItems(ListTableWithButtons.this.myElements);
                    int prev = selectedIndex - 1;
                    if (prev >= 0) {
                        ListTableWithButtons.this.myTableView.getComponent().getSelectionModel().setSelectionInterval(prev, prev);
                    } else if (selectedIndex < ListTableWithButtons.this.myElements.size()) {
                        ListTableWithButtons.this.myTableView.getComponent().getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
                    }
                }
            }
        }).disableUpDownActions().createPanel();
        ToolbarDecorator.findRemoveButton(this.myPanel).addCustomUpdater(new AnActionButtonUpdater(){

            @Override
            public boolean isEnabled(AnActionEvent e) {
                Object selection = ListTableWithButtons.this.getSelection();
                return selection != null && ListTableWithButtons.this.myIsEnabled && ListTableWithButtons.this.canDeleteElement(selection);
            }
        });
        ToolbarDecorator.findAddButton(this.myPanel).addCustomUpdater(new AnActionButtonUpdater(){

            @Override
            public boolean isEnabled(AnActionEvent e) {
                return ListTableWithButtons.this.myIsEnabled;
            }
        });
        this.myTableView.getComponent().setSelectionMode(0);
    }

    protected abstract ListTableModel createListModel();

    protected void setModified() {
        this.setChanged();
        this.notifyObservers();
    }

    protected List<T> getElements() {
        return this.myElements;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void setEnabled() {
        this.myTableView.getComponent().setEnabled(true);
        this.myIsEnabled = true;
    }

    public void setDisabled() {
        this.myTableView.getComponent().setEnabled(false);
        this.myIsEnabled = false;
    }

    public void stopEditing() {
        this.myTableView.stopEditing();
    }

    public void refreshValues() {
        this.myTableView.getComponent().repaint();
    }

    protected abstract T createElement();

    protected T getSelection() {
        int selIndex = this.myTableView.getComponent().getSelectionModel().getMinSelectionIndex();
        if (selIndex < 0) {
            return null;
        }
        return this.myElements.get(selIndex);
    }

    public void setValues(List<T> envVariables) {
        this.myElements.clear();
        for (T envVariable : envVariables) {
            this.myElements.add(this.cloneElement(envVariable));
        }
        this.myTableView.getTableViewModel().setItems(this.myElements);
    }

    protected abstract T cloneElement(T var1);

    protected abstract boolean canDeleteElement(T var1);

    protected static abstract class ElementsColumnInfoBase<T>
    extends ColumnInfo<T, String> {
        private DefaultTableCellRenderer myRenderer;

        protected ElementsColumnInfoBase(String name) {
            super(name);
        }

        public TableCellRenderer getRenderer(T element) {
            if (this.myRenderer == null) {
                this.myRenderer = new DefaultTableCellRenderer();
            }
            if (element != null) {
                this.myRenderer.setText((String)this.valueOf(element));
                this.myRenderer.setToolTipText(this.getDescription(element));
            }
            return this.myRenderer;
        }

        @Nullable
        protected abstract String getDescription(T var1);
    }
}

