/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RunContentDescriptor
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ui.RunContentDescriptor");
    private ExecutionConsole myExecutionConsole;
    private ProcessHandler myProcessHandler;
    private JComponent myComponent;
    private final String myDisplayName;
    private final Icon myIcon;
    private final String myHelpId;
    private boolean myActivateToolWindowWhenAdded = true;
    private long myExecutionId = 0L;
    private Computable<JComponent> myFocusComputable = null;
    private boolean myAutoFocusContent = false;
    private Content myContent;
    private Runnable myRestarter;

    public RunContentDescriptor(ExecutionConsole executionConsole, ProcessHandler processHandler, JComponent component, String displayName, Icon icon) {
        this.myExecutionConsole = executionConsole;
        this.myProcessHandler = processHandler;
        this.myComponent = component;
        this.myDisplayName = displayName;
        this.myIcon = icon;
        this.myHelpId = this.myExecutionConsole instanceof HelpIdProvider ? ((HelpIdProvider)((Object)this.myExecutionConsole)).getHelpId() : null;
        DataManager.registerDataProvider(this.myComponent, new DataProvider(){

            @Override
            public Object getData(@NonNls String dataId) {
                if (RunContentManager.RUN_CONTENT_DESCRIPTOR.is(dataId)) {
                    return RunContentDescriptor.this;
                }
                return null;
            }
        });
    }

    public RunContentDescriptor(ExecutionConsole executionConsole, ProcessHandler processHandler, JComponent component, String displayName) {
        this(executionConsole, processHandler, component, displayName, null);
    }

    public ExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public void dispose() {
        if (this.myExecutionConsole != null) {
            Disposer.dispose((Disposable)this.myExecutionConsole);
            this.myExecutionConsole = null;
        }
        if (this.myComponent != null) {
            DataManager.removeDataProvider(this.myComponent);
            this.myComponent = null;
        }
        this.myRestarter = null;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    public boolean isContentReuseProhibited() {
        return false;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public void setAttachedContent(Content content) {
        this.myContent = content;
    }

    public Content getAttachedContent() {
        return this.myContent;
    }

    public void setRestarter(Runnable runnable) {
        this.myRestarter = runnable;
    }

    public Runnable getRestarter() {
        return this.myRestarter;
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.hashCode() + "(" + this.getDisplayName() + ")";
    }

    public Computable<JComponent> getPreferredFocusComputable() {
        return this.myFocusComputable;
    }

    public void setFocusComputable(Computable<JComponent> focusComputable) {
        this.myFocusComputable = focusComputable;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }
}

