/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionEnvironmentBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.runners.ExecutionEnvironmentBuilder");
    @NotNull
    private RunProfile myRunProfile;
    @NotNull
    private ExecutionTarget myTarget;
    @NotNull
    private final Project myProject;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    @Nullable
    private RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    @Nullable
    private String myRunnerId;
    private boolean myAssignNewId;
    @NotNull
    private final Executor myExecutor;
    @Nullable
    private DataContext myDataContext;

    public ExecutionEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "<init>"));
        }
        this.myTarget = DefaultExecutionTarget.INSTANCE;
        this.myProject = project;
        this.myExecutor = executor;
    }

    public ExecutionEnvironmentBuilder(@NotNull ExecutionEnvironment copySource) {
        if (copySource == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "<init>"));
        }
        this.myTarget = DefaultExecutionTarget.INSTANCE;
        this.setTarget(copySource.getExecutionTarget());
        this.myProject = copySource.getProject();
        this.myRunnerAndConfigurationSettings = copySource.getRunnerAndConfigurationSettings();
        this.myRunProfile = copySource.getRunProfile();
        this.myRunnerSettings = copySource.getRunnerSettings();
        this.myConfigurationSettings = copySource.getConfigurationSettings();
        this.myRunnerId = copySource.getRunnerId();
        this.setContentToReuse(copySource.getContentToReuse());
        this.myExecutor = copySource.getExecutor();
    }

    public ExecutionEnvironmentBuilder setTarget(@NotNull ExecutionTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "setTarget"));
        }
        this.myTarget = target;
        return this;
    }

    public ExecutionEnvironmentBuilder setRunnerAndSettings(@NotNull ProgramRunner programRunner, @NotNull RunnerAndConfigurationSettings settings) {
        if (programRunner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "setRunnerAndSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "setRunnerAndSettings"));
        }
        this.myRunnerAndConfigurationSettings = settings;
        this.setRunProfile(settings.getConfiguration());
        this.setRunnerSettings(settings.getRunnerSettings(programRunner));
        this.setConfigurationSettings(settings.getConfigurationSettings(programRunner));
        this.setRunnerId(programRunner.getRunnerId());
        return this;
    }

    public ExecutionEnvironmentBuilder setRunnerSettings(@Nullable RunnerSettings runnerSettings) {
        this.myRunnerSettings = runnerSettings;
        return this;
    }

    public ExecutionEnvironmentBuilder setConfigurationSettings(@Nullable ConfigurationPerRunnerSettings configurationSettings) {
        this.myConfigurationSettings = configurationSettings;
        return this;
    }

    public ExecutionEnvironmentBuilder setContentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        return this;
    }

    public ExecutionEnvironmentBuilder setRunProfile(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "setRunProfile"));
        }
        this.myRunProfile = runProfile;
        return this;
    }

    public ExecutionEnvironmentBuilder setRunnerId(@Nullable String runnerId) {
        this.myRunnerId = runnerId;
        return this;
    }

    public ExecutionEnvironmentBuilder assignNewId() {
        this.myAssignNewId = true;
        return this;
    }

    public ExecutionEnvironmentBuilder setDataContext(@Nullable DataContext dataContext) {
        this.myDataContext = dataContext;
        return this;
    }

    @NotNull
    public ExecutionEnvironment build() {
        ExecutionEnvironment environment = new ExecutionEnvironment(this.myRunProfile, this.myExecutor, this.myTarget, this.myProject, this.myRunnerSettings, this.myConfigurationSettings, this.myContentToReuse, this.myRunnerAndConfigurationSettings, this.myRunnerId);
        if (this.myAssignNewId) {
            environment.assignNewExecutionId();
        }
        if (this.myDataContext != null) {
            environment.setDataContext(this.myDataContext);
        }
        ExecutionEnvironment executionEnvironment = environment;
        if (executionEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "build"));
        }
        return executionEnvironment;
    }
}

