/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionEnvironment
extends UserDataHolderBase {
    private static final AtomicLong myIdHolder = new AtomicLong(1L);
    @NotNull
    private final Project myProject;
    @NotNull
    private RunProfile myRunProfile;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private ExecutionTarget myTarget;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private final RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    @Nullable
    private String myRunnerId;
    private long myExecutionId;
    @Nullable
    private DataContext myDataContext;

    public ExecutionEnvironment() {
        this.myExecutionId = 0L;
        this.myProject = null;
        this.myContentToReuse = null;
        this.myRunnerAndConfigurationSettings = null;
        this.myExecutor = null;
    }

    public ExecutionEnvironment(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Project project) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        this(configuration.getConfiguration(), executor, DefaultExecutionTarget.INSTANCE, project, configuration.getRunnerSettings(runner), configuration.getConfigurationSettings(runner), null, null, runner.getRunnerId());
    }

    public ExecutionEnvironment(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull ExecutionTarget target, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Project project) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        this(configuration.getConfiguration(), executor, target, project, configuration.getRunnerSettings(runner), configuration.getConfigurationSettings(runner), null, configuration, runner.getRunnerId());
    }

    public ExecutionEnvironment(@NotNull RunProfile runProfile, @NotNull Executor executor, @NotNull Project project, @Nullable RunnerSettings runnerSettings) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        this(runProfile, executor, DefaultExecutionTarget.INSTANCE, project, runnerSettings, null, null, null, null);
    }

    public ExecutionEnvironment(@NotNull RunProfile runProfile, @NotNull Executor executor, @NotNull ExecutionTarget target, @NotNull Project project, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationSettings, @Nullable RunContentDescriptor contentToReuse, @Nullable RunnerAndConfigurationSettings settings, @Nullable String runnerId) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/ExecutionEnvironment", "<init>"));
        }
        this.myExecutionId = 0L;
        this.myExecutor = executor;
        this.myTarget = target;
        this.myRunProfile = runProfile;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
        this.myProject = project;
        this.myContentToReuse = contentToReuse;
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunnerId = runnerId;
        if (this.myContentToReuse != null) {
            Disposer.register((Disposable)this.myContentToReuse, (Disposable)new Disposable(){

                public void dispose() {
                    ExecutionEnvironment.this.myContentToReuse = null;
                }
            });
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironment", "getProject"));
        }
        return project;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myTarget;
        if (executionTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironment", "getExecutionTarget"));
        }
        return executionTarget;
    }

    @NotNull
    public RunProfile getRunProfile() {
        RunProfile runProfile = this.myRunProfile;
        if (runProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironment", "getRunProfile"));
        }
        return runProfile;
    }

    @Nullable
    public RunnerAndConfigurationSettings getRunnerAndConfigurationSettings() {
        return this.myRunnerAndConfigurationSettings;
    }

    @Nullable
    public RunContentDescriptor getContentToReuse() {
        return this.myContentToReuse;
    }

    @Nullable
    public String getRunnerId() {
        return this.myRunnerId;
    }

    @Nullable
    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    @Nullable
    public RunProfileState getState() throws ExecutionException {
        return this.myRunProfile.getState(this.myExecutor, this);
    }

    public long assignNewExecutionId() {
        this.myExecutionId = myIdHolder.incrementAndGet();
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myExecutor;
        if (executor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironment", "getExecutor"));
        }
        return executor;
    }

    public String toString() {
        if (this.myRunnerAndConfigurationSettings != null) {
            return this.myRunnerAndConfigurationSettings.getName();
        }
        if (this.myRunProfile != null) {
            return this.myRunProfile.getName();
        }
        if (this.myContentToReuse != null) {
            return this.myContentToReuse.getDisplayName();
        }
        return super.toString();
    }

    void setDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironment", "setDataContext"));
        }
        this.myDataContext = CachingDataContext.cacheIfNeed(dataContext);
    }

    @Nullable
    public DataContext getDataContext() {
        return this.myDataContext;
    }

    private static class CachingDataContext
    implements DataContext {
        private static final DataKey[] keys = new DataKey[]{LangDataKeys.PROJECT, LangDataKeys.PROJECT_FILE_DIRECTORY, LangDataKeys.EDITOR, LangDataKeys.VIRTUAL_FILE, LangDataKeys.MODULE, LangDataKeys.PSI_FILE};
        private final Map<String, Object> values = new HashMap<String, Object>();

        @NotNull
        static CachingDataContext cacheIfNeed(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionEnvironment$CachingDataContext", "cacheIfNeed"));
            }
            if (context instanceof CachingDataContext) {
                CachingDataContext cachingDataContext = (CachingDataContext)context;
                if (cachingDataContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironment$CachingDataContext", "cacheIfNeed"));
                }
                return cachingDataContext;
            }
            CachingDataContext cachingDataContext = new CachingDataContext(context);
            if (cachingDataContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironment$CachingDataContext", "cacheIfNeed"));
            }
            return cachingDataContext;
        }

        private CachingDataContext(DataContext context) {
            for (DataKey key : keys) {
                this.values.put(key.getName(), key.getData(context));
            }
        }

        @Override
        public Object getData(@NonNls String dataId) {
            return this.values.get(dataId);
        }
    }
}

