/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.BaseProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncGenericProgramRunner<Settings extends RunnerSettings>
extends BaseProgramRunner<Settings> {
    @Override
    protected final void execute(final @NotNull ExecutionEnvironment environment, final @Nullable ProgramRunner.Callback callback, final @NotNull Project project, final @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        this.prepare(project, environment, state).doWhenDone(new Consumer<RunProfileStarter>(){

            public void consume(final @Nullable RunProfileStarter result) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            AsyncGenericProgramRunner.startRunProfile(project, environment, state, callback, result);
                        }
                    }
                });
            }
        }).doWhenRejected((Consumer<String>)new NullableConsumer<String>(){

            public void consume(@Nullable String errorMessage) {
                if (project.isDisposed()) {
                    return;
                }
                ExecutionUtil.handleExecutionError(project, environment.getExecutor().getToolWindowId(), environment.getRunProfile(), new ExecutionException((String)ObjectUtils.chooseNotNull((Object)errorMessage, (Object)"Internal error")));
            }
        });
    }

    @NotNull
    protected abstract AsyncResult<RunProfileStarter> prepare(@NotNull Project var1, @NotNull ExecutionEnvironment var2, @NotNull RunProfileState var3) throws ExecutionException;

    private static void startRunProfile(@NotNull Project project, @NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, final @Nullable ProgramRunner.Callback callback, final @Nullable RunProfileStarter starter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        ExecutionManager.getInstance(project).startRunProfile(new RunProfileStarter(){

            @Override
            public RunContentDescriptor execute(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfileState state, @Nullable RunContentDescriptor contentToReuse, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AsyncGenericProgramRunner$3", "execute"));
                }
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/AsyncGenericProgramRunner$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/AsyncGenericProgramRunner$3", "execute"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/execution/runners/AsyncGenericProgramRunner$3", "execute"));
                }
                return BaseProgramRunner.postProcess(environment, starter == null ? null : starter.execute(project, executor, state, contentToReuse, environment), callback);
            }
        }, state, environment);
    }
}

