/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class ColoredOutputTypeRegistry {
    private final Map<String, Key> myRegisteredKeys = new HashMap<String, Key>();
    private static final TextAttributesKey[] myAnsiColorKeys = new TextAttributesKey[]{ConsoleHighlighter.BLACK, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN, ConsoleHighlighter.GRAY, ConsoleHighlighter.DARKGRAY, ConsoleHighlighter.RED_BRIGHT, ConsoleHighlighter.GREEN_BRIGHT, ConsoleHighlighter.YELLOW_BRIGHT, ConsoleHighlighter.BLUE_BRIGHT, ConsoleHighlighter.MAGENTA_BRIGHT, ConsoleHighlighter.CYAN_BRIGHT, ConsoleHighlighter.WHITE};

    public static ColoredOutputTypeRegistry getInstance() {
        return ServiceManager.getService(ColoredOutputTypeRegistry.class);
    }

    public Key getOutputKey(@NonNls String attribute) {
        String[] strings;
        Key key = this.myRegisteredKeys.get(attribute);
        if (key != null) {
            return key;
        }
        String completeAttribute = attribute;
        if (attribute.startsWith("\u001b[")) {
            attribute = attribute.substring(2);
        } else if (attribute.startsWith("[")) {
            attribute = attribute.substring(1);
        }
        if (attribute.endsWith("m")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        if (attribute.equals("0")) {
            return ProcessOutputTypes.STDOUT;
        }
        TextAttributes attrs = new TextAttributes();
        for (String string : strings = attribute.split(";")) {
            int value;
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (value == 1) {
                attrs.setFontType(1);
                continue;
            }
            if (value == 4) {
                attrs.setEffectType(EffectType.LINE_UNDERSCORE);
                continue;
            }
            if (value == 22) {
                attrs.setFontType(0);
                continue;
            }
            if (value == 24) {
                attrs.setEffectType(null);
                continue;
            }
            if (value >= 30 && value <= 37) {
                attrs.setForegroundColor(ColoredOutputTypeRegistry.getAnsiColor(value - 30));
                continue;
            }
            if (value == 38) continue;
            if (value == 39) {
                attrs.setForegroundColor(ColoredOutputTypeRegistry.getColorByKey(ConsoleViewContentType.NORMAL_OUTPUT_KEY));
                continue;
            }
            if (value >= 40 && value <= 47) {
                attrs.setBackgroundColor(ColoredOutputTypeRegistry.getAnsiColor(value - 40));
                continue;
            }
            if (value == 48) continue;
            if (value == 49) {
                attrs.setBackgroundColor(ColoredOutputTypeRegistry.getColorByKey(ConsoleViewContentType.NORMAL_OUTPUT_KEY));
                continue;
            }
            if (value >= 90 && value <= 97) {
                attrs.setForegroundColor(ColoredOutputTypeRegistry.getAnsiColor(value - 82));
                continue;
            }
            if (value < 100 || value > 107) continue;
            attrs.setBackgroundColor(ColoredOutputTypeRegistry.getAnsiColor(value - 92));
        }
        if (attrs.getEffectType() == EffectType.LINE_UNDERSCORE) {
            attrs.setEffectColor(attrs.getForegroundColor());
        }
        Key newKey = new Key(completeAttribute);
        ConsoleViewContentType contentType = new ConsoleViewContentType(completeAttribute, attrs);
        ConsoleViewContentType.registerNewConsoleViewType(newKey, contentType);
        this.myRegisteredKeys.put(completeAttribute, newKey);
        return newKey;
    }

    private static Color getAnsiColor(int value) {
        return ColoredOutputTypeRegistry.getColorByKey(ColoredOutputTypeRegistry.getAnsiColorKey(value));
    }

    private static Color getColorByKey(TextAttributesKey colorKey) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(colorKey).getForegroundColor();
    }

    public static TextAttributesKey getAnsiColorKey(int value) {
        if (value >= 16) {
            return ConsoleViewContentType.NORMAL_OUTPUT_KEY;
        }
        return myAnsiColorKeys[value];
    }
}

