/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class CapturingAnsiEscapesAwareProcessHandler
extends CapturingProcessHandler {
    public CapturingAnsiEscapesAwareProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler", "<init>"));
        }
        super(commandLine);
    }

    public CapturingAnsiEscapesAwareProcessHandler(Process process) {
        super(process);
    }

    @Override
    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new AnsiEscapesAwareAdapter(processOutput);
    }

    private static class AnsiEscapesAwareAdapter
    extends CapturingProcessAdapter
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder(){

            @Override
            protected Key getCurrentOutputAttributes(Key outputType) {
                return outputType;
            }
        };

        public AnsiEscapesAwareAdapter(ProcessOutput output) {
            super(output);
        }

        @Override
        public void onTextAvailable(ProcessEvent event, Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(event.getText(), outputType, this);
        }

        @Override
        public void coloredTextAvailable(String text, Key attributes) {
            this.addToOutput(text, attributes);
        }
    }
}

