/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilterFactory;
import com.intellij.execution.filters.Filter;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExceptionFilters {
    private ExceptionFilters() {
    }

    @NotNull
    public static List<Filter> getFilters(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/ExceptionFilters", "getFilters"));
        }
        ExceptionFilterFactory[] extensions = (ExceptionFilterFactory[])ExceptionFilterFactory.EP_NAME.getExtensions();
        ArrayList<Filter> filters = new ArrayList<Filter>(extensions.length);
        for (ExceptionFilterFactory extension : extensions) {
            filters.add(extension.create(searchScope));
        }
        ArrayList<Filter> arrayList = filters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionFilters", "getFilters"));
        }
        return arrayList;
    }
}

