/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.google.common.collect.Maps;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.pty4j.PtyProcess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.PtyCommandLine");

    @Override
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
        }
        if (SystemInfo.isUnix) {
            try {
                HashMap env = Maps.newHashMap();
                this.setupEnvironment(env);
                if (this.isRedirectErrorStream()) {
                    LOG.error("Launching process with PTY and redirected error stream is unsupported yet");
                }
                File workDirectory = this.getWorkDirectory();
                return PtyProcess.exec((String[])ArrayUtil.toStringArray(commands), (Map)env, (String)(workDirectory != null ? workDirectory.getPath() : null), (boolean)true);
            }
            catch (Throwable e) {
                LOG.error("Couldn't run process with PTY", e);
            }
        }
        return super.startProcess(commands);
    }
}

