/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ParamsGroup
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)ParamsGroup.class.getName());
    private String myGroupId;
    private ParametersList myGroupParams;

    public ParamsGroup(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ParamsGroup", "<init>"));
        }
        this.myGroupParams = new ParametersList();
        this.myGroupId = groupId;
    }

    public String getId() {
        return this.myGroupId;
    }

    public void addParameter(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ParamsGroup", "addParameter"));
        }
        this.myGroupParams.add(parameter);
    }

    public void addParameterAt(int index, @NotNull @NonNls String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configurations/ParamsGroup", "addParameterAt"));
        }
        this.myGroupParams.addAt(index, parameter);
    }

    public void addParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ParamsGroup", "addParameters"));
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParametersString(@NotNull @NonNls String parametersString) {
        if (parametersString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ParamsGroup", "addParametersString"));
        }
        this.addParameters(ParametersList.parse(parametersString));
    }

    public List<String> getParameters() {
        return this.myGroupParams.getList();
    }

    public ParametersList getParametersList() {
        return this.myGroupParams;
    }

    public ParamsGroup clone() {
        try {
            ParamsGroup clone = (ParamsGroup)super.clone();
            clone.myGroupId = this.myGroupId;
            clone.myGroupParams = this.myGroupParams.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.myGroupId;
    }
}

