/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationFactory {
    public static final Icon ADD_ICON = IconUtil.getAddIcon();
    private final ConfigurationType myType;

    protected ConfigurationFactory(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ConfigurationFactory", "<init>"));
        }
        this.myType = type;
    }

    public RunConfiguration createConfiguration(String name, RunConfiguration template) {
        RunConfiguration newConfiguration = template.clone();
        newConfiguration.setName(name);
        return newConfiguration;
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ConfigurationFactory", "isApplicable"));
        }
        return true;
    }

    public abstract RunConfiguration createTemplateConfiguration(Project var1);

    public RunConfiguration createTemplateConfiguration(Project project, RunManager runManager) {
        return this.createTemplateConfiguration(project);
    }

    public String getName() {
        return this.myType.getDisplayName();
    }

    public Icon getAddIcon() {
        return ADD_ICON;
    }

    public Icon getIcon(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ConfigurationFactory", "getIcon"));
        }
        return this.getIcon();
    }

    public Icon getIcon() {
        return this.myType.getIcon();
    }

    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.myType;
        if (configurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/ConfigurationFactory", "getType"));
        }
        return configurationType;
    }

    public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
    }

    public boolean isConfigurationSingletonByDefault() {
        return false;
    }

    public boolean canConfigurationBeSingleton() {
        return true;
    }
}

