/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Location<E extends PsiElement> {
    public static final DataKey<Location<?>> DATA_KEY = DataKey.create("Location");
    public static final DataKey<Location<?>[]> DATA_KEYS = DataKey.create("LocationArray");
    @Deprecated
    @NonNls
    public static final String LOCATION = DATA_KEY.getName();

    @NotNull
    public abstract E getPsiElement();

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> var1, boolean var2);

    @Nullable
    public VirtualFile getVirtualFile() {
        E psiElement = this.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return new OpenFileDescriptor(this.getProject(), virtualFile, this.getPsiElement().getTextOffset());
    }

    @Nullable
    public <Ancestor extends PsiElement> Location<Ancestor> getParent(Class<Ancestor> parentClass) {
        Iterator<Location<PsiElement>> ancestors = this.getAncestors(PsiElement.class, true);
        if (!ancestors.hasNext()) {
            return null;
        }
        Location<PsiElement> parent = ancestors.next();
        if (parentClass.isInstance(parent.getPsiElement())) {
            return parent;
        }
        return null;
    }

    @Nullable
    public <T extends PsiElement> Location<T> getAncestorOrSelf(Class<T> ancestorClass) {
        Iterator<Location<T>> ancestors = this.getAncestors(ancestorClass, false);
        if (!ancestors.hasNext()) {
            return null;
        }
        return ancestors.next();
    }

    @Nullable
    public <Ancestor extends PsiElement> Ancestor getParentElement(Class<Ancestor> parentClass) {
        return Location.safeGetPsiElement(this.getParent(parentClass));
    }

    @Nullable
    public static <T extends PsiElement> T safeGetPsiElement(Location<T> location) {
        return location != null ? (T)location.getPsiElement() : null;
    }

    @Nullable
    public static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    @NotNull
    public PsiLocation<E> toPsiLocation() {
        PsiLocation<E> psiLocation = new PsiLocation<E>(this.getProject(), this.getPsiElement());
        if (psiLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/Location", "toPsiLocation"));
        }
        return psiLocation;
    }

    @Nullable
    public abstract Module getModule();
}

