/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionTargetManager {
    public static final Topic<ExecutionTargetListener> TOPIC = Topic.create((String)"ExecutionTarget topic", ExecutionTargetListener.class);

    @NotNull
    public static ExecutionTargetManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionTargetManager", "getInstance"));
        }
        ExecutionTargetManager executionTargetManager = project.getComponent(ExecutionTargetManager.class);
        if (executionTargetManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManager", "getInstance"));
        }
        return executionTargetManager;
    }

    @NotNull
    public static ExecutionTarget getActiveTarget(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionTargetManager", "getActiveTarget"));
        }
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance(project).getActiveTarget();
        if (executionTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManager", "getActiveTarget"));
        }
        return executionTarget;
    }

    public static void setActiveTarget(@NotNull Project project, @NotNull ExecutionTarget target) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionTargetManager", "setActiveTarget"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ExecutionTargetManager", "setActiveTarget"));
        }
        ExecutionTargetManager.getInstance(project).setActiveTarget(target);
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsFor(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionTargetManager", "getTargetsFor"));
        }
        List<ExecutionTarget> list = ExecutionTargetManager.getInstance(project).getTargetsFor(settings);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManager", "getTargetsFor"));
        }
        return list;
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsToChooseFor(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionTargetManager", "getTargetsToChooseFor"));
        }
        List<ExecutionTarget> result = ExecutionTargetManager.getInstance(project).getTargetsFor(settings);
        if (result.size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result.get(0))) {
            List<ExecutionTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManager", "getTargetsToChooseFor"));
            }
            return list;
        }
        List<ExecutionTarget> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManager", "getTargetsToChooseFor"));
        }
        return list;
    }

    public static boolean canRun(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
        return settings != null && target != null && settings.canRunOn(target) && target.canRun(settings);
    }

    public static void update(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionTargetManager", "update"));
        }
        ExecutionTargetManager.getInstance(project).update();
    }

    @NotNull
    public abstract ExecutionTarget getActiveTarget();

    public abstract void setActiveTarget(@NotNull ExecutionTarget var1);

    @NotNull
    public abstract List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings var1);

    public abstract void update();
}

