/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.DoWhile;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class Iterate<T>
extends DoWhile {
    private final Iterator<T> myIterator;
    private boolean myIsDone;

    public Iterate(@NotNull Iterable<T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/Iterate", "<init>"));
        }
        this.myIterator = iterable.iterator();
        this.myIsDone = false;
    }

    @Override
    @NotNull
    protected final AsyncFuture<Boolean> body() {
        if (!this.myIterator.hasNext()) {
            this.myIsDone = true;
            AsyncFuture<Boolean> asyncFuture = AsyncFutureFactory.wrap(true);
            if (asyncFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/Iterate", "body"));
            }
            return asyncFuture;
        }
        AsyncFuture<Boolean> asyncFuture = this.process(this.myIterator.next());
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/Iterate", "body"));
        }
        return asyncFuture;
    }

    @NotNull
    protected abstract AsyncFuture<Boolean> process(T var1);

    @Override
    protected boolean condition() {
        return !this.myIsDone;
    }
}

