/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.DoOnce;
import com.intellij.concurrency.ResultConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class FinallyFuture<V>
implements AsyncFuture<V> {
    private final DoOnce myFinallyBlock;
    private final AsyncFuture<V> myInner;

    public FinallyFuture(@NotNull AsyncFuture<V> inner, @NotNull Runnable finallyBlock) {
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/FinallyFuture", "<init>"));
        }
        if (finallyBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/FinallyFuture", "<init>"));
        }
        this.myInner = inner;
        this.myFinallyBlock = new DoOnce(finallyBlock);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancel = this.myInner.cancel(mayInterruptIfRunning);
        if (cancel) {
            this.myFinallyBlock.execute();
        }
        return cancel;
    }

    @Override
    public boolean isCancelled() {
        return this.myInner.isDone();
    }

    @Override
    public boolean isDone() {
        return this.myInner.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            Object v = this.myInner.get();
            return v;
        }
        finally {
            this.myFinallyBlock.execute();
        }
    }

    @Override
    public void addConsumer(@NotNull Executor executor, final @NotNull ResultConsumer<V> consumer) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/FinallyFuture", "addConsumer"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/FinallyFuture", "addConsumer"));
        }
        this.myInner.addConsumer(executor, new ResultConsumer<V>(){

            @Override
            public void onSuccess(V value) {
                try {
                    FinallyFuture.this.myFinallyBlock.execute();
                    consumer.onSuccess(value);
                }
                catch (Throwable t) {
                    consumer.onFailure(t);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                try {
                    FinallyFuture.this.myFinallyBlock.execute();
                }
                catch (Throwable t1) {
                    t = t1;
                }
                consumer.onFailure(t);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/FinallyFuture", "get"));
        }
        boolean timeoutOccurred = false;
        try {
            void unit;
            Object v = this.myInner.get(timeout, (TimeUnit)unit);
            return v;
        }
        catch (TimeoutException t) {
            timeoutOccurred = true;
            throw t;
        }
        finally {
            if (!timeoutOccurred) {
                this.myFinallyBlock.execute();
            }
        }
    }
}

