/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.DefaultResultConsumer;
import com.intellij.concurrency.SameThreadExecutorWithTrampoline;
import org.jetbrains.annotations.NotNull;

public abstract class DoWhile {
    private final AsyncFutureResult<Boolean> myResult = AsyncFutureFactory.getInstance().createAsyncFutureResult();
    private final SameThreadExecutorWithTrampoline myExecutor = new SameThreadExecutorWithTrampoline();

    @NotNull
    public AsyncFutureResult<Boolean> getResult() {
        this.body().addConsumer(this.myExecutor, new MyConsumer());
        AsyncFutureResult<Boolean> asyncFutureResult = this.myResult;
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/DoWhile", "getResult"));
        }
        return asyncFutureResult;
    }

    @NotNull
    protected abstract AsyncFuture<Boolean> body();

    protected abstract boolean condition();

    private class MyConsumer
    extends DefaultResultConsumer<Boolean> {
        public MyConsumer() {
            super(DoWhile.this.myResult);
        }

        @Override
        public void onSuccess(Boolean value) {
            if (!value.booleanValue()) {
                DoWhile.this.myResult.set(false);
            } else if (!DoWhile.this.condition()) {
                DoWhile.this.myResult.set(true);
            } else {
                DoWhile.this.body().addConsumer(DoWhile.this.myExecutor, this);
            }
        }
    }
}

