/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.taskdefs;

import com.intellij.compiler.ant.Tag;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Target
extends Tag {
    public Target(@NonNls String name, @Nullable String depends, @Nullable String description, @Nullable String unlessCondition) {
        super("target", Target.getOptions(name, depends, description, unlessCondition));
    }

    public Target(@NonNls String name, @Nullable String depends, @Nullable String description, @Nullable String unlessCondition, @Nullable String xmlNsName, @Nullable String xmlNsValue) {
        super("target", Target.getOptions(name, depends, description, unlessCondition, xmlNsName, xmlNsValue));
    }

    private static Pair[] getOptions(String ... names) {
        ArrayList<Pair> options = new ArrayList<Pair>();
        options.add(new Pair((Object)"name", (Object)names[0]));
        Target.appendIfNonEmpty(options, "depends", names[1]);
        Target.appendIfNonEmpty(options, "description", names[2]);
        Target.appendIfNonEmpty(options, "unless", names[3]);
        if (names.length > 5) {
            Target.appendIfNonEmpty(options, names[4], names[5]);
        }
        return options.toArray(new Pair[options.size()]);
    }

    private static void appendIfNonEmpty(List<Pair> options, String paramName, String value) {
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            options.add(new Pair((Object)paramName, (Object)value));
        }
    }
}

