/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.PropertyFileGenerator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkBuildExtension {
    public static final ExtensionPointName<ChunkBuildExtension> EP_NAME = ExtensionPointName.create((String)"com.intellij.antBuildGen");

    @NotNull
    @NonNls
    public abstract String[] getTargets(ModuleChunk var1);

    public abstract void process(Project var1, ModuleChunk var2, GenerationOptions var3, CompositeGenerator var4);

    public void generateProjectTargets(Project project, GenerationOptions genOptions, CompositeGenerator generator) {
    }

    public void generateProperties(PropertyFileGenerator generator, Project project, GenerationOptions options) {
    }

    public void generateTasksForArtifact(Artifact artifact, boolean preprocessing, ArtifactAntGenerationContext context, CompositeGenerator generator) {
    }

    @Nullable
    public Pair<String, String> getArtifactXmlNs(ArtifactType artifactType) {
        return null;
    }

    public boolean needAntArtifactInstructions(ArtifactType type) {
        return true;
    }

    public void initArtifacts(Project project, GenerationOptions genOptions, CompositeGenerator generator) {
    }

    public List<String> getCleanTargetNames(Project project, GenerationOptions genOptions) {
        return Collections.emptyList();
    }

    public static String[] getAllTargets(ModuleChunk chunk) {
        ChunkBuildExtension[] extensions;
        ArrayList<String> allTargets = new ArrayList<String>();
        for (ChunkBuildExtension extension : extensions = (ChunkBuildExtension[])Extensions.getRootArea().getExtensionPoint(EP_NAME).getExtensions()) {
            ContainerUtil.addAll(allTargets, (Object[])extension.getTargets(chunk));
        }
        if (allTargets.isEmpty()) {
            allTargets.add(BuildProperties.getCompileTargetName(chunk.getName()));
        }
        return ArrayUtil.toStringArray(allTargets);
    }

    public static void process(CompositeGenerator generator, ModuleChunk chunk, GenerationOptions genOptions) {
        ChunkBuildExtension[] extensions;
        Project project = chunk.getProject();
        for (ChunkBuildExtension extension : extensions = (ChunkBuildExtension[])Extensions.getRootArea().getExtensionPoint(EP_NAME).getExtensions()) {
            extension.process(project, chunk, genOptions, generator);
        }
    }

    public static void generateAllProperties(PropertyFileGenerator propertyFileGenerator, Project project, GenerationOptions genOptions) {
        ChunkBuildExtension[] extensions;
        for (ChunkBuildExtension extension : extensions = (ChunkBuildExtension[])Extensions.getRootArea().getExtensionPoint(EP_NAME).getExtensions()) {
            extension.generateProperties(propertyFileGenerator, project, genOptions);
        }
    }
}

