/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.options.ExternalBuildOptionListener;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class CompilerTestUtil {
    private CompilerTestUtil() {
    }

    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance(project);
        compilerConfiguration.projectOpened();
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
        JpsJavaCompilerOptions javacSettings = JavacConfiguration.getOptions((Project)project, JavacConfiguration.class);
        javacSettings.setTestsUseExternalCompiler(true);
    }

    public static void scanSourceRootsToRecompile(Project project) {
        List<VirtualFile> roots = ProjectRootManager.getInstance(project).getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        TranslatingCompilerFilesMonitor.getInstance().scanSourceContent(new TranslatingCompilerFilesMonitor.ProjectRef(project), roots, roots.size(), true);
    }

    public static void saveApplicationSettings() {
        try {
            ProjectJdkTableImpl table = (ProjectJdkTableImpl)ProjectJdkTable.getInstance();
            Element root = new Element("application");
            root.addContent(JDomSerializationUtil.createComponentElement((String)"ProjectJdkTable").addContent((Collection)table.getState().cloneContent()));
            CompilerTestUtil.saveApplicationComponent(root, ((ProjectJdkTableImpl)ProjectJdkTable.getInstance()).getExportFiles()[0]);
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            Element fileTypesComponent = JDomSerializationUtil.createComponentElement((String)fileTypeManager.getComponentName());
            fileTypeManager.writeExternal(fileTypesComponent);
            CompilerTestUtil.saveApplicationComponent(new Element("application").addContent(fileTypesComponent), PathManager.getOptionsFile((NamedJDOMExternalizable)fileTypeManager));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (WriteExternalException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveApplicationComponent(Element root, File file) throws IOException {
        FileUtil.createParentDirs((File)file);
        JDOMUtil.writeDocument((Document)new Document(root), (File)file, (String)SystemProperties.getLineSeparator());
    }

    public static void enableExternalCompiler(final Project project) {
        new WriteAction(){

            @Override
            protected void run(Result result) {
                CompilerWorkspaceConfiguration.getInstance((Project)project).USE_OUT_OF_PROCESS_BUILD = true;
                ((ExternalBuildOptionListener)project.getMessageBus().syncPublisher(ExternalBuildOptionListener.TOPIC)).externalBuildOptionChanged(true);
                ApplicationManagerEx.getApplicationEx().doNotSave(false);
                JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
                table.addJdk(table.getInternalJdk());
            }
        }.execute();
    }

    public static void disableExternalCompiler(final Project project) {
        new WriteAction(){

            @Override
            protected void run(Result result) {
                CompilerWorkspaceConfiguration.getInstance((Project)project).USE_OUT_OF_PROCESS_BUILD = false;
                ((ExternalBuildOptionListener)project.getMessageBus().syncPublisher(ExternalBuildOptionListener.TOPIC)).externalBuildOptionChanged(false);
                ApplicationManagerEx.getApplicationEx().doNotSave(true);
                JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
                table.removeJdk(table.getInternalJdk());
                BuildManager.getInstance().stopWatchingProject(project);
            }
        }.execute();
    }
}

