/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;

public class MultipleCheckboxOptionsPanel
extends JPanel {
    private final InspectionProfileEntry owner;

    public MultipleCheckboxOptionsPanel(InspectionProfileEntry owner) {
        super(new GridBagLayout());
        this.owner = owner;
    }

    public void addCheckbox(String label, @NonNls String property) {
        boolean selected = MultipleCheckboxOptionsPanel.getPropertyValue(this.owner, property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        MultipleCheckboxOptionsPanel.configureCheckbox(this.owner, property, checkBox);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        Component[] components = this.getComponents();
        this.removeAll();
        for (Component component : components) {
            this.add(component, constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        this.add((Component)checkBox, constraints);
    }

    private static void configureCheckbox(InspectionProfileEntry owner, String property, JCheckBox checkBox) {
        ButtonModel model = checkBox.getModel();
        CheckboxChangeListener changeListener = new CheckboxChangeListener(owner, property, model);
        model.addChangeListener(changeListener);
    }

    public static void initAndConfigureCheckbox(InspectionProfileEntry owner, String property, JCheckBox checkBox) {
        checkBox.setSelected(MultipleCheckboxOptionsPanel.getPropertyValue(owner, property));
        MultipleCheckboxOptionsPanel.configureCheckbox(owner, property, checkBox);
    }

    private static boolean getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            Class<?> aClass = owner.getClass();
            Field field = aClass.getField(property);
            return field.getBoolean(owner);
        }
        catch (IllegalAccessException ignored) {
            return false;
        }
        catch (NoSuchFieldException ignored) {
            return false;
        }
    }

    private static class CheckboxChangeListener
    implements ChangeListener {
        private final InspectionProfileEntry owner;
        private final String property;
        private final ButtonModel model;

        CheckboxChangeListener(InspectionProfileEntry owner, String property, ButtonModel model) {
            this.owner = owner;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CheckboxChangeListener.setPropertyValue(this.owner, this.property, this.model.isSelected());
        }

        private static void setPropertyValue(InspectionProfileEntry owner, String property, boolean selected) {
            try {
                Class<?> aClass = owner.getClass();
                Field field = aClass.getField(property);
                field.setBoolean(owner, selected);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }
}

