/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class XmlSuppressionProvider {
    public static ExtensionPointName<XmlSuppressionProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlSuppressionProvider");

    public static boolean isSuppressed(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressionProvider", "isSuppressed"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/XmlSuppressionProvider", "isSuppressed"));
        }
        for (XmlSuppressionProvider provider : (XmlSuppressionProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isProviderAvailable(element.getContainingFile()) || !provider.isSuppressedFor(element, inspectionId)) continue;
            return true;
        }
        return false;
    }

    public static XmlSuppressionProvider getProvider(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressionProvider", "getProvider"));
        }
        for (XmlSuppressionProvider provider : (XmlSuppressionProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isProviderAvailable(file)) continue;
            return provider;
        }
        throw new RuntimeException("No providers found for " + file);
    }

    public abstract boolean isProviderAvailable(@NotNull PsiFile var1);

    public abstract boolean isSuppressedFor(@NotNull PsiElement var1, @NotNull String var2);

    public abstract void suppressForFile(@NotNull PsiElement var1, @NotNull String var2);

    public abstract void suppressForTag(@NotNull PsiElement var1, @NotNull String var2);
}

