/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BatchSuppressManager;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SuppressManager
implements BatchSuppressManager {
    public static SuppressManager getInstance() {
        return ServiceManager.getService(SuppressManager.class);
    }

    public static boolean isSuppressedInspectionName(PsiLiteralExpression expression) {
        PsiAnnotation annotation = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class, true, PsiCodeBlock.class, PsiField.class);
        return annotation != null && "java.lang.SuppressWarnings".equals(annotation.getQualifiedName());
    }

    @Override
    @NotNull
    public SuppressQuickFix[] createBatchSuppressActions(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/SuppressManager", "createBatchSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = BatchSuppressManager.SERVICE.getInstance().createBatchSuppressActions(key);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressManager", "createBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    @NotNull
    public abstract SuppressIntentionAction[] createSuppressActions(@NotNull HighlightDisplayKey var1);
}

