/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public abstract class LocalQuickFixOnPsiElement
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LocalQuickFixAndIntentionAction");
    protected final SmartPsiElementPointer<PsiElement> myStartElement;
    protected final SmartPsiElementPointer<PsiElement> myEndElement;

    protected LocalQuickFixOnPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "<init>"));
        }
        this(element, element);
    }

    public LocalQuickFixOnPsiElement(PsiElement startElement, PsiElement endElement) {
        PsiFile endContainingFile;
        if (startElement == null || endElement == null) {
            this.myEndElement = null;
            this.myStartElement = null;
            return;
        }
        LOG.assertTrue(startElement.isValid());
        PsiFile startContainingFile = startElement.getContainingFile();
        PsiFile psiFile = endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        if (startElement != endElement) {
            LOG.assertTrue(endElement.isValid());
            LOG.assertTrue(startContainingFile == endContainingFile, (Object)"Both elements must be from the same file");
        }
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        this.myStartElement = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndElement = endElement == startElement ? null : SmartPointerManager.getInstance(project).createSmartPsiElementPointer(endElement, endContainingFile);
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "getName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "isAvailable"));
        }
        return true;
    }

    protected boolean isAvailable() {
        if (this.myStartElement == null) {
            return false;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        PsiFile file = this.myStartElement.getContainingFile();
        Project project = this.myStartElement.getProject();
        return startElement != null && endElement != null && startElement.isValid() && (endElement == startElement || endElement.isValid()) && file != null && this.isAvailable(project, file, startElement, endElement);
    }

    public PsiElement getStartElement() {
        return this.myStartElement == null ? null : this.myStartElement.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndElement == null ? null : this.myEndElement.getElement();
    }

    @NotNull
    public abstract String getText();

    @Override
    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/LocalQuickFixOnPsiElement", "applyFix"));
        }
        this.applyFix();
    }

    public void applyFix() {
        PsiElement endElement;
        if (this.myStartElement == null) {
            return;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement psiElement = endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        if (startElement == null || endElement == null) {
            return;
        }
        PsiFile file = startElement.getContainingFile();
        if (file == null) {
            return;
        }
        this.invoke(file.getProject(), file, startElement, endElement);
    }

    public abstract void invoke(@NotNull Project var1, @NotNull PsiFile var2, @NotNull PsiElement var3, @NotNull PsiElement var4);
}

