/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.LightCodeInsightTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightDaemonAnalyzerTestCase
extends LightCodeInsightTestCase {
    private final FileTreeAccessFilter myJavaFilesFilter = new FileTreeAccessFilter();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(LightDaemonAnalyzerTestCase.getProject())).prepareForTest();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
    }

    @Override
    protected void tearDown() throws Exception {
        ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(LightDaemonAnalyzerTestCase.getProject())).cleanupAfterTest();
        super.tearDown();
    }

    protected void runTest() throws Throwable {
        final Throwable[] throwable = new Throwable[]{null};
        CommandProcessor.getInstance().executeCommand(LightDaemonAnalyzerTestCase.getProject(), new Runnable(){

            @Override
            public void run() {
                try {
                    LightDaemonAnalyzerTestCase.this.doRunTest();
                }
                catch (Throwable t) {
                    throwable[0] = t;
                }
            }
        }, "", null);
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkInfos) {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkInfos, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestNewInference(@NonNls String filePath, boolean checkWarnings, boolean checkInfos) {
        PsiResolveHelperImpl helper = (PsiResolveHelperImpl)JavaPsiFacade.getInstance(LightDaemonAnalyzerTestCase.getProject()).getResolveHelper();
        helper.setTestHelper((PsiInferenceHelper)new PsiGraphInferenceHelper(LightDaemonAnalyzerTestCase.getPsiManager()));
        try {
            this.configureByFile(filePath);
            this.doTestConfiguredFile(checkWarnings, checkInfos, filePath);
        }
        finally {
            helper.setTestHelper(null);
        }
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkWeakWarnings, checkInfos, filePath);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkInfos, @Nullable String filePath) {
        this.doTestConfiguredFile(checkWarnings, false, checkInfos, filePath);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, @Nullable String filePath) {
        LightDaemonAnalyzerTestCase.getJavaFacade().setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.myTestRootDisposable);
        ExpectedHighlightingData data = new ExpectedHighlightingData(LightDaemonAnalyzerTestCase.getEditor().getDocument(), checkWarnings, checkWeakWarnings, checkInfos);
        this.checkHighlighting(data, this.composeLocalPath(filePath));
    }

    @Nullable
    private String composeLocalPath(@Nullable String filePath) {
        return filePath != null ? this.getTestDataPath() + "/" + filePath : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHighlighting(ExpectedHighlightingData data, String filePath) {
        data.init();
        PsiDocumentManager.getInstance(LightDaemonAnalyzerTestCase.getProject()).commitAllDocuments();
        LightDaemonAnalyzerTestCase.getFile().getText();
        this.myJavaFilesFilter.allowTreeAccessForFile(LightDaemonAnalyzerTestCase.getVFile());
        LightDaemonAnalyzerTestCase.getJavaFacade().setAssertOnFileLoadingFilter((VirtualFileFilter)this.myJavaFilesFilter, this.myTestRootDisposable);
        try {
            List<HighlightInfo> infos = this.doHighlighting();
            data.checkResult(infos, LightDaemonAnalyzerTestCase.getEditor().getDocument().getText(), filePath);
        }
        finally {
            LightDaemonAnalyzerTestCase.getJavaFacade().setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.myTestRootDisposable);
        }
    }

    protected HighlightTestInfo doTestFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase", "doTestFile"));
        }
        return new HighlightTestInfo(this.getTestRootDisposable(), new String[]{filePath}){

            public HighlightTestInfo doTest() {
                String path = (String)UsefulTestCase.assertOneElement((Object[])this.filePaths);
                LightDaemonAnalyzerTestCase.this.configureByFile(path);
                ExpectedHighlightingData data = new ExpectedHighlightingData(myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, myFile);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                LightDaemonAnalyzerTestCase.this.checkHighlighting(data, LightDaemonAnalyzerTestCase.this.composeLocalPath(path));
                return this;
            }
        };
    }

    @NotNull
    protected List<HighlightInfo> highlightErrors() {
        List<HighlightInfo> list = this.doHighlighting(HighlightSeverity.ERROR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase", "highlightErrors"));
        }
        return list;
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance(LightDaemonAnalyzerTestCase.getProject()).commitAllDocuments();
        TIntArrayList toIgnoreList = new TIntArrayList();
        if (!this.doFolding()) {
            toIgnoreList.add(1);
        }
        if (!this.doInspections()) {
            toIgnoreList.add(7);
            toIgnoreList.add(12);
        }
        int[] toIgnore = toIgnoreList.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : toIgnoreList.toNativeArray();
        Editor editor = LightDaemonAnalyzerTestCase.getEditor();
        PsiFile file = LightDaemonAnalyzerTestCase.getFile();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageManager.getInstance(file.getProject()).getTopLevelFile(file);
        }
        List list = CodeInsightTestFixtureImpl.instantiateAndRun((PsiFile)file, (Editor)editor, (int[])toIgnore, (boolean)false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase", "doHighlighting"));
        }
        return list;
    }

    protected List<HighlightInfo> doHighlighting(HighlightSeverity minSeverity) {
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), minSeverity);
    }

    protected boolean doFolding() {
        return false;
    }

    protected boolean doInspections() {
        return true;
    }
}

