/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    private final Lookup myLookup;
    private final int myOffset;
    private final int myInvocationCount;

    CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, CompletionType completionType, int offset, int invocationCount, Lookup lookup) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/CompletionParameters", "<init>"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/completion/CompletionParameters", "<init>"));
        }
        assert (offset >= position.getTextRange().getStartOffset());
        this.myPosition = position;
        assert (position.isValid());
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
        this.myLookup = lookup;
    }

    public CompletionParameters delegateToClassName() {
        return this.withType(CompletionType.CLASS_NAME).withInvocationCount(this.myInvocationCount - 1);
    }

    public CompletionParameters withType(CompletionType type) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, type, this.myOffset, this.myInvocationCount, this.myLookup);
    }

    public CompletionParameters withInvocationCount(int newCount) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, this.myCompletionType, this.myOffset, newCount, this.myLookup);
    }

    @NotNull
    public PsiElement getPosition() {
        PsiElement psiElement = this.myPosition;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getPosition"));
        }
        return psiElement;
    }

    @NotNull
    public Lookup getLookup() {
        Lookup lookup = this.myLookup;
        if (lookup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getLookup"));
        }
        return lookup;
    }

    @Nullable
    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getOriginalFile"));
        }
        return psiFile;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getCompletionType"));
        }
        return completionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public boolean isAutoPopup() {
        return this.myInvocationCount == 0;
    }

    public CompletionParameters withPosition(PsiElement element, int offset) {
        return new CompletionParameters(element, this.myOriginalFile, this.myCompletionType, offset, this.myInvocationCount, this.myLookup);
    }

    public boolean isExtendedCompletion() {
        return this.myCompletionType == CompletionType.BASIC && this.myInvocationCount >= 2;
    }

    public Editor getEditor() {
        return this.myLookup.getEditor();
    }
}

