/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionLocation
implements UserDataHolder {
    private final CompletionParameters myCompletionParameters;
    private final ProcessingContext myProcessingContext = new ProcessingContext();

    public CompletionLocation(CompletionParameters completionParameters) {
        this.myCompletionParameters = completionParameters;
    }

    public CompletionParameters getCompletionParameters() {
        return this.myCompletionParameters;
    }

    public CompletionType getCompletionType() {
        return this.myCompletionParameters.getCompletionType();
    }

    public Project getProject() {
        return this.myCompletionParameters.getPosition().getProject();
    }

    public ProcessingContext getProcessingContext() {
        return this.myProcessingContext;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/CompletionLocation", "getUserData"));
        }
        return (T)this.myProcessingContext.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/CompletionLocation", "putUserData"));
        }
        this.myProcessingContext.put(key, value);
    }
}

