/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompletionInitializationContext {
    public static final OffsetKey START_OFFSET = OffsetKey.create("startOffset", false);
    public static final OffsetKey SELECTION_END_OFFSET = OffsetKey.create("selectionEnd");
    public static final OffsetKey IDENTIFIER_END_OFFSET = OffsetKey.create("identifierEnd");
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz";
    private final Editor myEditor;
    private final PsiFile myFile;
    private final CompletionType myCompletionType;
    private final OffsetMap myOffsetMap;
    private String myDummyIdentifier = "IntellijIdeaRulezzz ";

    public CompletionInitializationContext(Editor editor, PsiFile file, CompletionType completionType) {
        this.myEditor = editor;
        this.myFile = file;
        this.myCompletionType = completionType;
        this.myOffsetMap = new OffsetMap(editor.getDocument());
        this.myOffsetMap.addOffset(START_OFFSET, CompletionInitializationContext.calcStartOffset(editor));
        this.myOffsetMap.addOffset(SELECTION_END_OFFSET, CompletionInitializationContext.calcSelectionEnd(editor));
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, CompletionInitializationContext.calcDefaultIdentifierEnd(editor, CompletionInitializationContext.calcSelectionEnd(editor)));
    }

    private static int calcSelectionEnd(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.hasSelection() ? selectionModel.getSelectionEnd() : editor.getCaretModel().getOffset();
    }

    public static int calcStartOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset();
    }

    static int calcDefaultIdentifierEnd(Editor editor, int startFrom) {
        int idEnd;
        CharSequence text = editor.getDocument().getCharsSequence();
        for (idEnd = startFrom; idEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(idEnd)); ++idEnd) {
        }
        return idEnd;
    }

    public void setDummyIdentifier(@NotNull String dummyIdentifier) {
        if (dummyIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/CompletionInitializationContext", "setDummyIdentifier"));
        }
        this.myDummyIdentifier = dummyIdentifier;
    }

    @NotNull
    public Language getPositionLanguage() {
        Language language = PsiUtilBase.getLanguageInEditor(this.getEditor(), this.getProject());
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getPositionLanguage"));
        }
        return language;
    }

    public String getDummyIdentifier() {
        return this.myDummyIdentifier;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getEditor"));
        }
        return editor;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getCompletionType"));
        }
        return completionType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getOffsetMap"));
        }
        return offsetMap;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(START_OFFSET);
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(SELECTION_END_OFFSET);
    }

    public int getIdentifierEndOffset() {
        return this.myOffsetMap.getOffset(IDENTIFIER_END_OFFSET);
    }

    public int getReplacementOffset() {
        return this.getIdentifierEndOffset();
    }

    public void setReplacementOffset(int idEnd) {
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, idEnd);
    }
}

