/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableNotNullManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + NullableNotNullManager.class.getName()));
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    public static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable"};
    public static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull"};

    public NullableNotNullManager() {
        Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "hasNullability"));
        }
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    private static void addAllIfNotPresent(Collection<String> collection, String ... annotations) {
        for (String annotation : annotations) {
            LOG.assertTrue(annotation != null);
            if (collection.contains(annotation)) continue;
            collection.add(annotation);
        }
    }

    public void setNotNulls(String ... annotations) {
        this.myNotNulls.clear();
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNotNulls, DEFAULT_NOT_NULLS);
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNotNulls, annotations);
    }

    public void setNullables(String ... annotations) {
        this.myNullables.clear();
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNullables, DEFAULT_NULLABLES);
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNullables, annotations);
    }

    public String getDefaultNullable() {
        return this.myDefaultNullable;
    }

    @Nullable
    public String getNullable(PsiModifierListOwner owner) {
        PsiAnnotation annotation = this.findNullabilityAnnotation(owner, false, true);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    public void setDefaultNullable(@NotNull String defaultNullable) {
        if (defaultNullable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "setDefaultNullable"));
        }
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
    }

    public String getDefaultNotNull() {
        return this.myDefaultNotNull;
    }

    @Nullable
    public String getNotNull(PsiModifierListOwner owner) {
        PsiAnnotation annotation = this.findNullabilityAnnotation(owner, false, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    public void setDefaultNotNull(@NotNull String defaultNotNull) {
        if (defaultNotNull == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "setDefaultNotNull"));
        }
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
    }

    @Nullable
    private PsiAnnotation findNullabilityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        PsiAnnotation annotation;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "findNullabilityAnnotation"));
        }
        HashSet qNames = ContainerUtil.newHashSet(nullable ? this.getNullables() : this.getNotNulls());
        PsiAnnotation psiAnnotation = annotation = checkBases && (owner instanceof PsiClass || owner instanceof PsiMethod) ? AnnotationUtil.findAnnotationInHierarchy(owner, qNames) : AnnotationUtil.findAnnotation(owner, qNames);
        if (annotation != null) {
            return annotation;
        }
        if (owner instanceof PsiParameter && !TypeConversionUtil.isPrimitiveAndNotNull(((PsiParameter)owner).getType())) {
            if (AnnotationUtil.isAnnotated(owner, nullable ? Arrays.asList(DEFAULT_NOT_NULLS) : Arrays.asList(DEFAULT_NULLABLES), checkBases, false)) {
                return null;
            }
            return NullableNotNullManager.findContainerAnnotation(owner, nullable ? "javax.annotation.ParametersAreNullableByDefault" : "javax.annotation.ParametersAreNonnullByDefault");
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "isNullable"));
        }
        return this.findNullabilityAnnotation(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "isNotNull"));
        }
        return this.findNullabilityAnnotation(owner, checkBases, false) != null;
    }

    @Nullable
    private static PsiAnnotation findContainerAnnotation(PsiModifierListOwner owner, String annotationFQN) {
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            PsiAnnotation annotation;
            if (element instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, annotationFQN)) != null) {
                return annotation;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiPackage, annotationFQN);
        }
        return null;
    }

    public List<String> getNullables() {
        return this.myNullables;
    }

    public List<String> getNotNulls() {
        return this.myNotNulls;
    }

    public boolean hasDefaultValues() {
        int i;
        if (DEFAULT_NULLABLES.length != this.getNullables().size() || DEFAULT_NOT_NULLS.length != this.getNotNulls().size()) {
            return false;
        }
        if (!this.myDefaultNotNull.equals("org.jetbrains.annotations.NotNull") || !this.myDefaultNullable.equals("org.jetbrains.annotations.Nullable")) {
            return false;
        }
        for (i = 0; i < DEFAULT_NULLABLES.length; ++i) {
            if (this.getNullables().get(i).equals(DEFAULT_NULLABLES[i])) continue;
            return false;
        }
        for (i = 0; i < DEFAULT_NOT_NULLS.length; ++i) {
            if (this.getNotNulls().get(i).equals(DEFAULT_NOT_NULLS[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element getState() {
        Element component = new Element("component");
        if (this.hasDefaultValues()) {
            return component;
        }
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)component);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return component;
    }

    @Override
    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
            if (this.myNullables.isEmpty()) {
                Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
            }
            if (this.myNotNulls.isEmpty()) {
                Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "isNullable"));
        }
        return !NullableNotNullManager.isNotNull(owner) && NullableNotNullManager.getInstance(owner.getProject()).isNullable(owner, true);
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/NullableNotNullManager", "isNotNull"));
        }
        return NullableNotNullManager.getInstance(owner.getProject()).isNotNull(owner, true);
    }
}

