/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationInvocationHandler;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    @NonNls
    public static final String NOT_NULL_SIMPLE_NAME = "NotNull";
    @NonNls
    public static final String NULLABLE_SIMPLE_NAME = "Nullable";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    @NonNls
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    @NonNls
    public static final String NON_NLS_SIMPLE_NAME = "NonNls";
    @NonNls
    public static final String PROPERTY_KEY_SIMPLE_NAME = "PropertyKey";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    @NonNls
    public static final String TEST_ONLY_SIMPLE_NAME = "TestOnly";
    public static final String LANGUAGE = "org.intellij.lang.annotations.Language";
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (annotationNames.length == 0) {
            return null;
        }
        Set<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : new HashSet<String>(Arrays.asList(annotationNames));
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        PsiAnnotation[] allAnnotations;
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (listOwner == null) {
            return null;
        }
        PsiModifierList list = listOwner.getModifierList();
        if (list == null) {
            return null;
        }
        for (PsiAnnotation annotation : allAnnotations = list.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!annotationNames.contains(qualifiedName)) continue;
            return annotation;
        }
        if (!skipExternal) {
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(listOwner.getProject());
            for (String annotationName : annotationNames) {
                PsiAnnotation annotation;
                annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation[] findAnnotations(PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
        }
        if (modifierListOwner == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] annotations = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = null;
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            if (result == null) {
                result = new ArrayList<PsiAnnotation>();
            }
            result.add(psiAnnotation);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        if (listOwner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)listOwner;
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
            return AnnotationUtil.findAnnotationInHierarchy(methodSignature, annotationNames, method, null, JavaPsiFacade.getInstance(method.getProject()).getResolveHelper());
        }
        if (listOwner instanceof PsiClass) {
            return AnnotationUtil.findAnnotationInHierarchy((PsiClass)listOwner, annotationNames, null);
        }
        if (listOwner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)listOwner;
            return AnnotationUtil.doFindAnnotationInHierarchy(parameter, annotationNames, null);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation doFindAnnotationInHierarchy(PsiParameter parameter, Set<String> annotationNames, @Nullable Set<PsiModifierListOwner> visited) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annotationNames);
        if (annotation != null) {
            return annotation;
        }
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)scope;
        PsiClass aClass = method.getContainingClass();
        PsiElement parent = parameter.getParent();
        if (aClass == null || !(parent instanceof PsiParameterList)) {
            return null;
        }
        int index = ((PsiParameterList)parent).getParameterIndex(parameter);
        HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiAnnotation insuper;
            PsiParameter[] superParameters;
            PsiMethod superMethod = superSignature.getMethod();
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiModifierListOwner)superMethod) || !resolveHelper.isAccessible(superMethod, parameter, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length || (insuper = AnnotationUtil.doFindAnnotationInHierarchy(superParameters[index], annotationNames, (Set<PsiModifierListOwner>)visited)) == null) continue;
            return insuper;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiClass psiClass, Set<String> annotationNames, @Nullable Set<PsiClass> processed) {
        PsiClass[] superClasses;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        for (PsiClass superClass : superClasses = psiClass.getSupers()) {
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add((PsiClass)superClass)) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)superClass, annotationNames);
            if (annotation != null) {
                return annotation;
            }
            PsiAnnotation annotationInHierarchy = AnnotationUtil.findAnnotationInHierarchy(superClass, annotationNames, (Set<PsiClass>)processed);
            if (annotationInHierarchy == null) continue;
            return annotationInHierarchy;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull HierarchicalMethodSignature signature, @NotNull Set<String> annotationNames, @NotNull PsiElement place, @Nullable Set<PsiMethod> processed, @NotNull PsiResolveHelper resolveHelper) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiMethod superMethod = superSignature.getMethod();
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add((PsiMethod)superMethod) || !resolveHelper.isAccessible(superMethod, place, null)) continue;
            PsiAnnotation direct = AnnotationUtil.findAnnotation((PsiModifierListOwner)superMethod, annotationNames);
            if (direct != null) {
                return direct;
            }
            PsiAnnotation superResult = AnnotationUtil.findAnnotationInHierarchy(superSignature, annotationNames, place, (Set<PsiMethod>)processed, resolveHelper);
            if (superResult == null) continue;
            return superResult;
        }
        return null;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, Collection<String> annotations) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, false);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, Collection<String> annotations, boolean checkHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, checkHierarchy, true);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, Collection<String> annotations, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        for (String annotation : annotations) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation, checkHierarchy, skipExternal)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, true, null);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal, @Nullable Set<PsiMember> processed) {
        block11: {
            PsiClass[] superClasses;
            block12: {
                PsiMethod[] superMethods;
                if (listOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (!skipExternal && ExternalAnnotationsManager.getInstance(listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!checkHierarchy) break block11;
                if (!(listOwner instanceof PsiMethod)) break block12;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet();
                }
                if (!processed.add((PsiMember)method)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, checkHierarchy, skipExternal, (Set<PsiMember>)processed)) continue;
                    return true;
                }
                break block11;
            }
            if (!(listOwner instanceof PsiClass)) break block11;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, checkHierarchy, skipExternal, (Set<PsiMember>)processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotatingApplicable"));
        }
        return AnnotationUtil.isAnnotatingApplicable(elt, NullableNotNullManager.getInstance(elt.getProject()).getDefaultNullable());
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt, String annotationFQN) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotatingApplicable"));
        }
        Project project = elt.getProject();
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(project).findClass(annotationFQN, elt.getResolveScope()) != null;
    }

    public static boolean isJetbrainsAnnotation(@NonNls String simpleName) {
        return ArrayUtil.find((Object[])SIMPLE_NAMES, (Object)simpleName) != -1;
    }

    public static boolean checkAnnotatedUsingPatterns(PsiModifierListOwner owner, Collection<String> annotations) {
        PsiModifierList modList;
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        ArrayList<String> fqns = null;
        for (String fqn : annotations) {
            boolean isPattern = fqn.endsWith("*");
            if (!isPattern && AnnotationUtil.isAnnotated(owner, fqn, false)) {
                return true;
            }
            if (!isPattern) continue;
            if (fqns == null) {
                PsiAnnotation[] annos;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : annos = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(PsiNameValuePair pair) {
        PsiAnnotation annotation = PsiTreeUtil.getParentOfType(pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance(pair.getProject()).findClass(fqn, pair.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name = pair.getName();
            return (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClass.findMethodsByName(name != null ? name : "value", false));
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, Set<PsiModifierListOwner> visited) {
        Object[] externalAnnotations;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "getAllAnnotations"));
        }
        PsiModifierList list = owner.getModifierList();
        Object[] annotations = PsiAnnotation.EMPTY_ARRAY;
        if (list != null) {
            annotations = list.getAnnotations();
        }
        if ((externalAnnotations = ExternalAnnotationsManager.getInstance(owner.getProject()).findExternalAnnotations(owner)) != null) {
            annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])externalAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (inHierarchy) {
            PsiParameter parameter;
            PsiElement scope;
            if (owner instanceof PsiClass) {
                for (PsiClass superClass : ((PsiClass)owner).getSupers()) {
                    if (visited == null) {
                        visited = new THashSet();
                    }
                    if (!visited.add((PsiModifierListOwner)superClass)) continue;
                    annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superClass, inHierarchy, (Set<PsiModifierListOwner>)visited));
                }
            } else if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                PsiClass aClass = method.getContainingClass();
                if (aClass != null) {
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null)) continue;
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superMethod, inHierarchy, (Set<PsiModifierListOwner>)visited));
                    }
                }
            } else if (owner instanceof PsiParameter && (scope = (parameter = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiClass aClass = method.getContainingClass();
                PsiElement parent = parameter.getParent();
                if (aClass != null && parent instanceof PsiParameterList) {
                    int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiParameter[] superParameters;
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length) continue;
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superParameters[index], inHierarchy, (Set<PsiModifierListOwner>)visited));
                    }
                }
            }
        }
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "getAllAnnotations"));
        }
        return annotations;
    }

    public static boolean isInsideAnnotation(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiNameValuePair.class, PsiArrayInitializerMemberValue.class) != null;
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "getStringAttributeValue"));
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static Boolean getBooleanAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "getBooleanAttributeValue"));
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Class<T> annotationClass) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy(listOwner, Collections.singleton(annotationClass.getName()));
        if (annotation == null) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationInvocationHandler(annotationClass, annotation)));
    }

    static {
        SIMPLE_NAMES = new String[]{NOT_NULL_SIMPLE_NAME, NULLABLE_SIMPLE_NAME, NON_NLS_SIMPLE_NAME, PROPERTY_KEY_SIMPLE_NAME, TEST_ONLY_SIMPLE_NAME, "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add(NULLABLE);
        ALL_ANNOTATIONS.add(NOT_NULL);
    }
}

