/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.AnalysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private SearchScope myScope;
    private boolean mySearchInLibraries;
    @Type
    protected int myType;
    protected Set<VirtualFile> myFilesSet;
    protected boolean myIncludeTestSource;

    public AnalysisScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
    }

    public AnalysisScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = null;
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
    }

    public AnalysisScope(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = null;
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = null;
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<VirtualFile> virtualFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myFilesSet = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setScope(SearchScope scope) {
        this.myScope = scope;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    @NotNull
    protected PsiElementVisitor createFileSearcher() {
        final FileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : (this.myModules != null && !this.myModules.isEmpty() ? ProjectRootManager.getInstance(this.myModules.get(0).getProject()).getFileIndex() : (this.myElement != null ? ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex() : (this.myProject != null ? ProjectRootManager.getInstance(this.myProject).getFileIndex() : null)));
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        PsiRecursiveElementVisitor psiRecursiveElementVisitor = new PsiRecursiveElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$1", "visitFile"));
                }
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (!AnalysisScope.this.myIncludeTestSource && (fileIndex == null || fileIndex.isInTestSourceContent(virtualFile))) {
                        return;
                    }
                    if (!AnalysisScope.shouldHighlightFile(file)) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile);
                    if (indicator != null) {
                        indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
                        Project project = file.getProject();
                        String text = AnalysisScope.displayProjectRelativePath(virtualFile, project);
                        indicator.setText2(text);
                    }
                }
            }
        };
        if (psiRecursiveElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "createFileSearcher"));
        }
        return psiRecursiveElementVisitor;
    }

    private static String displayProjectRelativePath(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "displayProjectRelativePath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "displayProjectRelativePath"));
        }
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), project, false, false);
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "contains"));
        }
        return this.contains(psiElement.getContainingFile().getVirtualFile());
    }

    public boolean contains(VirtualFile file) {
        if (this.myFilesSet == null) {
            if (this.myType == 8) {
                if (this.myScope instanceof GlobalSearchScope) {
                    return ((GlobalSearchScope)this.myScope).contains(file);
                }
                if (this.myScope instanceof LocalSearchScope) {
                    return ((LocalSearchScope)this.myScope).isInScope(file);
                }
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && (this.myIncludeTestSource || !index.isInTestSourceContent(file));
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    protected void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet<VirtualFile>(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 8) {
            this.myFilesSet = new HashSet<VirtualFile>();
            this.accept(this.createFileSearcher());
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        this.accept(visitor, !ApplicationManager.getApplication().isReadAccessAllowed());
    }

    protected void accept(final @NotNull PsiElementVisitor visitor, final boolean needReadAction) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        if (this.myType == 9) {
            PsiManager psiManager = PsiManager.getInstance(this.myProject);
            ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            for (VirtualFile file : this.myFilesSet) {
                if (!this.myIncludeTestSource && index.isInTestSourceContent(file) || AnalysisScope.processFile(file, visitor, psiManager, needReadAction)) continue;
                return;
            }
        } else if (this.myScope instanceof GlobalSearchScope) {
            final PsiManager psiManager = PsiManager.getInstance(this.myProject);
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            ContentIterator contentIterator = new ContentIterator(){

                @Override
                public boolean processFile(final @NotNull VirtualFile fileOrDir) {
                    if (fileOrDir == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$2", "processFile"));
                    }
                    boolean isInScope = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                        public Boolean compute() {
                            if (!AnalysisScope.this.myIncludeTestSource && projectFileIndex.isInTestSourceContent(fileOrDir)) {
                                return false;
                            }
                            return ((GlobalSearchScope)AnalysisScope.this.myScope).contains(fileOrDir);
                        }
                    });
                    return !isInScope || AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
                }
            };
            projectFileIndex.iterateContent(contentIterator);
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator);
                }
            }
        } else if (this.myScope instanceof LocalSearchScope) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiElement[] psiElements = ((LocalSearchScope)AnalysisScope.this.myScope).getScope();
                    LinkedHashSet<PsiFile> files = new LinkedHashSet<PsiFile>();
                    for (PsiElement element : psiElements) {
                        PsiFile file = element.getContainingFile();
                        if (file == null || !files.add(file)) continue;
                        file.accept(visitor);
                    }
                }
            });
        } else if (this.myModule != null) {
            final ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(this.myModule).getFileIndex();
            final PsiManager psiManager = PsiManager.getInstance(this.myModule.getProject());
            moduleFileIndex.iterateContent(new ContentIterator(){

                @Override
                public boolean processFile(@NotNull VirtualFile fileOrDir) {
                    if (fileOrDir == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$4", "processFile"));
                    }
                    return AnalysisScope.this.processFile(fileOrDir, visitor, moduleFileIndex, psiManager, needReadAction);
                }
            });
        } else if (this.myModules != null) {
            for (Module module : this.myModules) {
                final PsiManager psiManager = PsiManager.getInstance(module.getProject());
                final ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                moduleFileIndex.iterateContent(new ContentIterator(){

                    @Override
                    public boolean processFile(@NotNull VirtualFile fileOrDir) {
                        if (fileOrDir == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$5", "processFile"));
                        }
                        return AnalysisScope.this.processFile(fileOrDir, visitor, moduleFileIndex, psiManager, needReadAction);
                    }
                });
            }
        } else if (this.myElement instanceof PsiDirectory) {
            this.accept((PsiDirectory)this.myElement, visitor, needReadAction);
        } else if (this.myElement != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    AnalysisScope.this.myElement.accept(visitor);
                }
            });
        } else if (this.myProject != null) {
            final PsiManager psiManager = PsiManager.getInstance(this.myProject);
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            projectFileIndex.iterateContent(new ContentIterator(){

                @Override
                public boolean processFile(@NotNull VirtualFile fileOrDir) {
                    if (fileOrDir == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$7", "processFile"));
                    }
                    return AnalysisScope.this.processFile(fileOrDir, visitor, projectFileIndex, psiManager, needReadAction);
                }
            });
        }
    }

    private boolean processFile(@NotNull VirtualFile fileOrDir, @NotNull PsiElementVisitor visitor, @NotNull FileIndex projectFileIndex, @NotNull PsiManager psiManager, boolean needReadAction) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (projectFileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (fileOrDir.isDirectory()) {
            return true;
        }
        if (ProjectCoreUtil.isProjectOrWorkspaceFile(fileOrDir)) {
            return true;
        }
        if (projectFileIndex.isInContent(fileOrDir) && (this.myIncludeTestSource || !projectFileIndex.isInTestSourceContent(fileOrDir)) && !AnalysisScope.isInGeneratedSources(fileOrDir, psiManager.getProject())) {
            return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
        }
        return true;
    }

    private static boolean isInGeneratedSources(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "isInGeneratedSources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "isInGeneratedSources"));
        }
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            if (!filter.isGeneratedSource(file, project)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFile(@NotNull VirtualFile fileOrDir, final @NotNull PsiElementVisitor visitor, final @NotNull PsiManager psiManager, boolean needReadAction) {
        PsiFile file;
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        AccessToken accessToken = ReadAction.start();
        try {
            if (!fileOrDir.isValid()) {
                boolean bl = false;
                return bl;
            }
            file = psiManager.findFile(fileOrDir);
            if (file == null) {
                boolean bl = true;
                return bl;
            }
            if (!AnalysisScope.shouldHighlightFile(file)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            accessToken.finish();
        }
        if (needReadAction) {
            PsiDocumentManager.getInstance(psiManager.getProject()).commitAndRunReadAction(new Runnable(){

                @Override
                public void run() {
                    AnalysisScope.doProcessFile(visitor, psiManager, file);
                }
            });
        } else {
            AnalysisScope.doProcessFile(visitor, psiManager, file);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    protected static boolean shouldHighlightFile(PsiFile file) {
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(Module module) {
        switch (this.myType) {
            case 1: {
                return true;
            }
            case 4: {
                return this.myModule == module;
            }
            case 7: {
                return this.myModules.contains(module);
            }
        }
        return false;
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, @NotNull PsiFile file) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "doProcessFile"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "doProcessFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/analysis/AnalysisScope", "doProcessFile"));
        }
        file.accept(visitor);
        psiManager.dropResolveCaches();
        InjectedLanguageManager.getInstance(file.getProject()).dropFileCaches(file);
    }

    protected void accept(@NotNull PsiDirectory dir, final @NotNull PsiElementVisitor visitor, final boolean needReadAction) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        Project project = dir.getProject();
        final PsiManager psiManager = PsiManager.getInstance(project);
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, new ContentIterator(){

            @Override
            public boolean processFile(@NotNull VirtualFile fileOrDir) {
                if (fileOrDir == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$9", "processFile"));
                }
                if (!AnalysisScope.this.myIncludeTestSource && index.isInTestSourceContent(fileOrDir)) {
                    return true;
                }
                if (!fileOrDir.isDirectory()) {
                    return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
                }
                return true;
            }
        });
    }

    public boolean isValid() {
        if (this.myProject != null) {
            return true;
        }
        if (this.myModule != null && !this.myModule.isDisposed()) {
            return true;
        }
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        return this.myType == 9 || this.myType == 8 || this.myElement != null && this.myElement.isValid();
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    public String fun(@NotNull Module module) {
                        if (module == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$10", "fun"));
                        }
                        return AnalysisScope.pathToName(module.getModuleFilePath());
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                return AnalysisScopeBundle.message("scope.file", AnalysisScope.getPresentableUrl((PsiFileSystemItem)this.myElement));
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", AnalysisScope.getPresentableUrl((PsiFileSystemItem)this.myElement));
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.virtual.files", new Object[0]);
            }
        }
        return "";
    }

    private static String getPresentableUrl(@NotNull PsiFileSystemItem element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "getPresentableUrl"));
        }
        VirtualFile virtualFile = element.getVirtualFile();
        assert (virtualFile != null) : element;
        return virtualFile.getPresentableUrl();
    }

    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    @NotNull
                    public String fun(@NotNull Module module) {
                        if (module == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$11", "fun"));
                        }
                        String string = module.getName();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope$11", "fun"));
                        }
                        return string;
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                String relativePath = this.getRelativePath();
                return relativePath != null ? AnalysisScopeBundle.message("scope.file", relativePath) : "Current File";
            }
            case 2: {
                String relativeDirPath = this.getRelativePath();
                return relativeDirPath != null ? AnalysisScopeBundle.message("scope.directory", relativeDirPath) : "Current Directory";
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
            }
        }
        return "";
    }

    @Nullable
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject());
        if (relativePath.length() > 100) {
            return null;
        }
        return relativePath;
    }

    @NotNull
    private static String pathToName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "pathToName"));
        }
        File file = new File(path);
        String string = FileUtil.getNameWithoutExtension((File)file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "pathToName"));
        }
        return string;
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    public boolean checkScopeWritable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "checkScopeWritable"));
        }
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        return !FileModificationService.getInstance().prepareVirtualFilesForWrite(project, this.myFilesSet);
    }

    public void invalidate() {
        if (this.myType != 9) {
            this.myFilesSet = null;
        } else {
            Iterator<VirtualFile> i = this.myFilesSet.iterator();
            while (i.hasNext()) {
                VirtualFile virtualFile = i.next();
                if (virtualFile != null && virtualFile.isValid()) continue;
                i.remove();
            }
        }
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest ? index.isInTestSourceContent(directory) : !index.isInTestSourceContent(directory);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest ? index.isInTestSourceContent(file) : !index.isInTestSourceContent(file);
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "getNarrowedComplementaryScope"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        AnalysisScope analysisScope = AnalysisScope.collectScopes(defaultProject, modules);
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getNarrowedComplementaryScope"));
        }
        return analysisScope;
    }

    @NotNull
    protected static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull HashSet<Module> modules) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "collectScopes"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "collectScopes"));
        }
        if (modules.isEmpty()) {
            AnalysisScope analysisScope = new AnalysisScope(defaultProject);
            if (analysisScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "collectScopes"));
            }
            return analysisScope;
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        AnalysisScope analysisScope = new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()]));
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "collectScopes"));
        }
        return analysisScope;
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, @NotNull Module[] allModules) {
        if (fromModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "getExportBackwardDependencies"));
        }
        if (allModules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "getExportBackwardDependencies"));
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getExportBackwardDependencies"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module, @NotNull Module[] allModules) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "getDirectBackwardDependencies"));
        }
        if (allModules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "getDirectBackwardDependencies"));
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance(dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDirectBackwardDependencies"));
        }
        return hashSet;
    }

    @NotNull
    protected static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "getAllInterestingModules"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope", "getAllInterestingModules"));
        }
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        HashSet<Module> hashSet = modules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getAllInterestingModules"));
        }
        return hashSet;
    }

    @NotNull
    public SearchScope toSearchScope() {
        switch (this.myType) {
            case 8: {
                SearchScope searchScope = this.myScope;
                if (searchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return searchScope;
            }
            case 2: {
                GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 3: {
                LocalSearchScope localSearchScope = new LocalSearchScope(this.myElement);
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return localSearchScope;
            }
            case 6: {
                LocalSearchScope localSearchScope = LocalSearchScope.EMPTY;
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return localSearchScope;
            }
            case 4: {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                GlobalSearchScope globalSearchScope = this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 7: {
                SearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
                for (Module module : this.myModules) {
                    scope = ((SearchScope)scope).union(GlobalSearchScope.moduleScope(module));
                }
                GlobalSearchScope globalSearchScope = scope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 1: {
                GlobalSearchScope globalSearchScope = this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScopesCore.projectProductionScope(this.myProject);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 9: {
                GlobalSearchScope globalSearchScope = new GlobalSearchScope(){

                    @Override
                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$12", "contains"));
                        }
                        return AnalysisScope.this.myFilesSet.contains(file);
                    }

                    @Override
                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        if (file1 == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$12", "compare"));
                        }
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/AnalysisScope$12", "compare"));
                        }
                        return 0;
                    }

                    @Override
                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope$12", "isSearchInModuleContent"));
                        }
                        return false;
                    }

                    @Override
                    public boolean isSearchInLibraries() {
                        return false;
                    }
                };
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
        }
        LOG.error("invalid type " + this.myType);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
        }
        return globalSearchScope;
    }

    public boolean isAnalyzeTestsByDefault() {
        switch (this.myType) {
            case 2: {
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(((PsiDirectory)this.myElement).getVirtualFile());
            }
            case 3: {
                PsiFile containingFile = this.myElement.getContainingFile();
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(containingFile.getVirtualFile());
            }
            case 4: {
                return AnalysisScope.isTestOnly(this.myModule);
            }
            case 7: {
                for (Module module : this.myModules) {
                    if (AnalysisScope.isTestOnly(module)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTestOnly(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/AnalysisScope", "isTestOnly"));
        }
        return ModuleRootManager.getInstance(module).getSourceRootUrls(false).length == 0;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public static @interface Type {
    }
}

