/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class SyncDateFormat {
    private final DateFormat myDelegate;

    public SyncDateFormat(@NotNull DateFormat delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/SyncDateFormat", "<init>"));
        }
        this.myDelegate = delegate;
    }

    public synchronized Date parse(@NotNull String s) throws ParseException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/SyncDateFormat", "parse"));
        }
        return this.myDelegate.parse(s);
    }

    public synchronized String format(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/SyncDateFormat", "format"));
        }
        return this.myDelegate.format(date);
    }

    public synchronized String format(long time) {
        return this.myDelegate.format(time);
    }

    public synchronized void setTimeZone(@NotNull TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/SyncDateFormat", "setTimeZone"));
        }
        this.myDelegate.setTimeZone(timeZone);
    }

    public DateFormat getDelegate() {
        return this.myDelegate;
    }

    public synchronized String toPattern() {
        if (this.myDelegate instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.myDelegate).toPattern();
        }
        throw new UnsupportedOperationException("Delegate must be of SimpleDateFormat type");
    }
}

