/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.text.SyncDateFormat;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class DateFormatUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.util.text.DateFormatUtil");
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final long DAY_FACTOR = 86400000L;
    private static final SyncDateFormat DATE_FORMAT;
    private static final SyncDateFormat TIME_FORMAT;
    private static final SyncDateFormat TIME_WITH_SECONDS_FORMAT;
    private static final SyncDateFormat DATE_TIME_FORMAT;
    private static final SyncDateFormat ABOUT_DATE_FORMAT;
    private static final SyncDateFormat SHORT_DATE_FORMAT;
    private static final long[] DENOMINATORS;
    private static final Period[] PERIODS;

    private DateFormatUtil() {
    }

    public static long getDifferenceInDays(Date startDate, Date endDate) {
        return (endDate.getTime() - startDate.getTime() + 86400000L - 1000L) / 86400000L;
    }

    @NotNull
    public static SyncDateFormat getDateFormat() {
        SyncDateFormat syncDateFormat = DATE_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "getDateFormat"));
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeFormat() {
        SyncDateFormat syncDateFormat = TIME_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "getTimeFormat"));
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeWithSecondsFormat() {
        SyncDateFormat syncDateFormat = TIME_WITH_SECONDS_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "getTimeWithSecondsFormat"));
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getDateTimeFormat() {
        SyncDateFormat syncDateFormat = DATE_TIME_FORMAT;
        if (syncDateFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "getDateTimeFormat"));
        }
        return syncDateFormat;
    }

    @NotNull
    public static String formatTime(@NotNull Date time) {
        if (time == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/DateFormatUtil", "formatTime"));
        }
        String string = DateFormatUtil.formatTime(time.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatTime"));
        }
        return string;
    }

    @NotNull
    public static String formatTime(long time) {
        String string = DateFormatUtil.getTimeFormat().format(time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatTime"));
        }
        return string;
    }

    @NotNull
    public static String formatTimeWithSeconds(@NotNull Date time) {
        if (time == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/DateFormatUtil", "formatTimeWithSeconds"));
        }
        String string = DateFormatUtil.formatTimeWithSeconds(time.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatTimeWithSeconds"));
        }
        return string;
    }

    @NotNull
    public static String formatTimeWithSeconds(long time) {
        String string = DateFormatUtil.getTimeWithSecondsFormat().format(time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatTimeWithSeconds"));
        }
        return string;
    }

    @NotNull
    public static String formatDate(@NotNull Date time) {
        if (time == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/DateFormatUtil", "formatDate"));
        }
        String string = DateFormatUtil.formatDate(time.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatDate"));
        }
        return string;
    }

    @NotNull
    public static String formatDate(long time) {
        String string = DateFormatUtil.getDateFormat().format(time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatDate"));
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/DateFormatUtil", "formatPrettyDate"));
        }
        String string = DateFormatUtil.formatPrettyDate(date.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatPrettyDate"));
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDate(long time) {
        String string = DateFormatUtil.doFormatPretty(time, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatPrettyDate"));
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(Date date) {
        String string = DateFormatUtil.formatDateTime(date.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatDateTime"));
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(long time) {
        String string = DateFormatUtil.getDateTimeFormat().format(time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatDateTime"));
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDateTime(Date date) {
        String string = DateFormatUtil.formatPrettyDateTime(date.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatPrettyDateTime"));
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDateTime(long time) {
        String string = DateFormatUtil.doFormatPretty(time, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatPrettyDateTime"));
        }
        return string;
    }

    @NotNull
    private static String doFormatPretty(long time, boolean formatTime) {
        boolean isYesterday;
        boolean isToday;
        long delta;
        long currentTime = Clock.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentTime);
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (formatTime && (delta = currentTime - time) <= 3600000L && delta >= 0L) {
            String string = CommonBundle.message("date.format.minutes.ago", (int)Math.rint((double)delta / 60000.0));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "doFormatPretty"));
            }
            return string;
        }
        boolean bl = isToday = currentYear == year && currentDayOfYear == dayOfYear;
        if (isToday) {
            String result = CommonBundle.message("date.format.today", new Object[0]);
            if (formatTime) {
                result = result + " " + TIME_FORMAT.format(time);
            }
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "doFormatPretty"));
            }
            return string;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl2 = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            String result = CommonBundle.message("date.format.yesterday", new Object[0]);
            if (formatTime) {
                result = result + " " + TIME_FORMAT.format(time);
            }
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "doFormatPretty"));
            }
            return string;
        }
        String string = formatTime ? DATE_TIME_FORMAT.format(time) : DATE_FORMAT.format(time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "doFormatPretty"));
        }
        return string;
    }

    @NotNull
    public static String formatDuration(long delta) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < DENOMINATORS.length; ++i) {
            long denominator = DENOMINATORS[i];
            int n = (int)(delta / denominator);
            if (n == 0) continue;
            buf.append(DateFormatUtil.composeDurationMessage(PERIODS[i], n));
            buf.append(' ');
            delta %= denominator;
        }
        if (buf.length() == 0) {
            String string = CommonBundle.message("date.format.less.than.a.minute", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatDuration"));
            }
            return string;
        }
        String string = buf.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatDuration"));
        }
        return string;
    }

    private static String composeDurationMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.n.years", n);
    }

    @NotNull
    public static String formatFrequency(long time) {
        String string = CommonBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(time, 0L));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatFrequency"));
        }
        return string;
    }

    @NotNull
    public static String formatBetweenDates(long d1, long d2) {
        int i;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            String string = CommonBundle.message("date.format.right.now", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatBetweenDates"));
            }
            return string;
        }
        int n = -1;
        for (i = 0; i < DENOMINATORS.length; ++i) {
            long denominator = DENOMINATORS[i];
            if (delta < denominator) continue;
            n = (int)(delta / denominator);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                String string = CommonBundle.message("date.format.a.few.moments.ago", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatBetweenDates"));
                }
                return string;
            }
            String string = DateFormatUtil.someTimeAgoMessage(PERIODS[i], n);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatBetweenDates"));
            }
            return string;
        }
        if (d2 < d1) {
            if (n <= 0) {
                String string = CommonBundle.message("date.format.in.a.few.moments", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatBetweenDates"));
                }
                return string;
            }
            String string = DateFormatUtil.composeInSomeTimeMessage(PERIODS[i], n);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatBetweenDates"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatBetweenDates"));
        }
        return "";
    }

    @NotNull
    public static String formatAboutDialogDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/DateFormatUtil", "formatAboutDialogDate"));
        }
        String string = ABOUT_DATE_FORMAT.format(date);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatAboutDialogDate"));
        }
        return string;
    }

    @NotNull
    public static String formatShortDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/DateFormatUtil", "formatShortDate"));
        }
        String string = SHORT_DATE_FORMAT.format(date);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/DateFormatUtil", "formatShortDate"));
        }
        return string;
    }

    private static String someTimeAgoMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days.ago", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes.ago", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours.ago", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months.ago", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks.ago", n);
            }
        }
        return CommonBundle.message("date.format.n.years.ago", n);
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.in.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.in.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.in.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.in.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.in.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.in.n.years", n);
    }

    private static SyncDateFormat[] getDateTimeFormats() {
        DateFormat[] formats = new DateFormat[4];
        boolean loaded = false;
        try {
            if (SystemInfo.isWin7OrNewer) {
                loaded = DateFormatUtil.getWindowsFormats(formats);
            } else if (SystemInfo.isMac) {
                loaded = DateFormatUtil.getMacFormats(formats);
            } else if (SystemInfo.isUnix) {
                loaded = DateFormatUtil.getUnixFormats(formats);
            }
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        if (!loaded) {
            formats[0] = DateFormat.getDateInstance(3);
            formats[1] = DateFormat.getTimeInstance(3);
            formats[2] = DateFormat.getTimeInstance(2);
            formats[3] = DateFormat.getDateTimeInstance(3, 3);
        }
        SyncDateFormat[] synced = new SyncDateFormat[4];
        for (int i = 0; i < formats.length; ++i) {
            synced[i] = new SyncDateFormat(formats[i]);
        }
        return synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getMacFormats(DateFormat[] formats) {
        boolean MacFormatterNoStyle = false;
        boolean MacFormatterShortStyle = true;
        int MacFormatterMediumStyle = 2;
        int MacFormatterBehavior_10_4 = 1040;
        ID autoReleasePool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
        try {
            ID dateFormatter = Foundation.invoke("NSDateFormatter", "new", new Object[0]);
            Foundation.invoke(dateFormatter, Foundation.createSelector("setFormatterBehavior:"), 1040);
            formats[0] = DateFormatUtil.invokeFormatter(dateFormatter, 0, 1);
            formats[1] = DateFormatUtil.invokeFormatter(dateFormatter, 1, 0);
            formats[2] = DateFormatUtil.invokeFormatter(dateFormatter, 2, 0);
            formats[3] = DateFormatUtil.invokeFormatter(dateFormatter, 1, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            Foundation.invoke(autoReleasePool, Foundation.createSelector("release"), new Object[0]);
        }
    }

    private static DateFormat invokeFormatter(ID dateFormatter, int timeStyle, int dateStyle) {
        Foundation.invoke(dateFormatter, Foundation.createSelector("setTimeStyle:"), timeStyle);
        Foundation.invoke(dateFormatter, Foundation.createSelector("setDateStyle:"), dateStyle);
        String format = Foundation.toStringViaUTF8(Foundation.invoke(dateFormatter, Foundation.createSelector("dateFormat"), new Object[0]));
        assert (format != null);
        return new SimpleDateFormat(format.trim());
    }

    private static boolean getUnixFormats(DateFormat[] formats) {
        String localeStr = EnvironmentUtil.getValue("LC_TIME");
        if (localeStr == null) {
            return false;
        }
        int p = (localeStr = localeStr.trim()).indexOf(46);
        if (p > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p);
        }
        Locale locale = (p = localeStr.indexOf(95)) < 0 ? new Locale(localeStr) : new Locale(localeStr.substring(0, p), localeStr.substring(p + 1));
        formats[0] = DateFormat.getDateInstance(3, locale);
        formats[1] = DateFormat.getTimeInstance(3, locale);
        formats[2] = DateFormat.getTimeInstance(2, locale);
        formats[3] = DateFormat.getDateTimeInstance(3, 3, locale);
        return true;
    }

    private static boolean getWindowsFormats(DateFormat[] formats) {
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class);
        int dataSize = 128;
        Memory data = new Memory((long)dataSize);
        int rv = kernel32.GetLocaleInfoEx(Kernel32.LOCALE_NAME_USER_DEFAULT, 31, (Pointer)data, dataSize);
        assert (rv > 1) : kernel32.GetLastError();
        String shortDate = new String(data.getCharArray(0L, rv - 1));
        rv = kernel32.GetLocaleInfoEx(Kernel32.LOCALE_NAME_USER_DEFAULT, 121, (Pointer)data, dataSize);
        assert (rv > 1) : kernel32.GetLastError();
        String shortTime = StringUtil.replace(new String(data.getCharArray(0L, rv - 1)), "tt", "a");
        rv = kernel32.GetLocaleInfoEx(Kernel32.LOCALE_NAME_USER_DEFAULT, 4099, (Pointer)data, dataSize);
        assert (rv > 1) : kernel32.GetLastError();
        String mediumTime = StringUtil.replace(new String(data.getCharArray(0L, rv - 1)), "tt", "a");
        formats[0] = new SimpleDateFormat(shortDate);
        formats[1] = new SimpleDateFormat(shortTime);
        formats[2] = new SimpleDateFormat(mediumTime);
        formats[3] = new SimpleDateFormat(shortDate + " " + shortTime);
        return true;
    }

    static {
        SyncDateFormat[] formats = DateFormatUtil.getDateTimeFormats();
        DATE_FORMAT = formats[0];
        TIME_FORMAT = formats[1];
        TIME_WITH_SECONDS_FORMAT = formats[2];
        DATE_TIME_FORMAT = formats[3];
        ABOUT_DATE_FORMAT = new SyncDateFormat(DateFormat.getDateInstance(1, Locale.US));
        SHORT_DATE_FORMAT = new SyncDateFormat(DateFormat.getDateInstance(2, Locale.US));
        DENOMINATORS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
        PERIODS = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final String LOCALE_NAME_USER_DEFAULT = null;
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, Pointer var3, int var4);

        public int GetLastError();
    }

    private static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

