/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import jsr166e.extra.SequenceLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentStringEnumerator
extends PersistentEnumeratorDelegate<String>
implements AbstractStringEnumerator {
    private static final int STRIPE_POWER = 4;
    private static final int STRIPE_COUNT = 16;
    private static final int STRIPE_MASK = 15;
    @Nullable
    private final SLRUMap<Integer, Integer>[] myHashcodeToIdCache;
    @Nullable
    private final SLRUMap<Integer, String>[] myIdToStringCache;
    @Nullable
    private final Lock[] myStripeLocks;

    public PersistentStringEnumerator(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, null);
    }

    public PersistentStringEnumerator(@NotNull File file, @Nullable PagedFileStorage.StorageLockContext storageLockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, 4096, storageLockContext);
    }

    public PersistentStringEnumerator(@NotNull File file, boolean cacheLastMappings) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, 4096, cacheLastMappings, null);
    }

    public PersistentStringEnumerator(@NotNull File file, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, initialSize, null);
    }

    public PersistentStringEnumerator(@NotNull File file, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, initialSize, false, lockContext);
    }

    private PersistentStringEnumerator(@NotNull File file, int initialSize, boolean cacheLastMappings, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        super(file, new EnumeratorStringDescriptor(), initialSize, lockContext);
        if (cacheLastMappings) {
            this.myIdToStringCache = new SLRUMap[16];
            this.myHashcodeToIdCache = new SLRUMap[16];
            this.myStripeLocks = new Lock[16];
            int protectedSize = 8192;
            int probationalSize = 8192;
            for (int i = 0; i < 16; ++i) {
                this.myHashcodeToIdCache[i] = new SLRUMap(protectedSize / 16, probationalSize / 16);
                this.myIdToStringCache[i] = new SLRUMap(protectedSize / 16, probationalSize / 16);
                this.myStripeLocks[i] = new SequenceLock();
            }
        } else {
            this.myIdToStringCache = null;
            this.myHashcodeToIdCache = null;
            this.myStripeLocks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enumerate(@Nullable String value) throws IOException {
        int valueHashCode = -1;
        int stripe = -1;
        if (this.myHashcodeToIdCache != null && value != null) {
            Integer cachedId;
            valueHashCode = value.hashCode();
            stripe = Math.abs(valueHashCode) & 0xF;
            this.myStripeLocks[stripe].lock();
            try {
                cachedId = this.myHashcodeToIdCache[stripe].get(valueHashCode);
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
            if (cachedId != null) {
                int stripe2 = this.idStripe(cachedId);
                this.myStripeLocks[stripe2].lock();
                try {
                    String s = this.myIdToStringCache[stripe2].get(cachedId);
                    if (s != null && value.equals(s)) {
                        int n = cachedId;
                        return n;
                    }
                }
                finally {
                    this.myStripeLocks[stripe2].unlock();
                }
            }
        }
        int enumerate = super.enumerate(value);
        if (stripe != -1) {
            Integer enumeratedInteger;
            this.myStripeLocks[stripe].lock();
            try {
                enumeratedInteger = enumerate;
                this.myHashcodeToIdCache[stripe].put(valueHashCode, enumeratedInteger);
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
            int stripe2 = this.idStripe(enumerate);
            this.myStripeLocks[stripe2].lock();
            try {
                this.myIdToStringCache[stripe2].put(enumeratedInteger, value);
            }
            finally {
                this.myStripeLocks[stripe2].unlock();
            }
        }
        return enumerate;
    }

    private int idStripe(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return Math.abs(h ^ h >>> 7 ^ h >>> 4) & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String valueOf(int idx) throws IOException {
        String s;
        int stripe = -1;
        if (this.myIdToStringCache != null) {
            stripe = this.idStripe(idx);
            this.myStripeLocks[stripe].lock();
            try {
                s = this.myIdToStringCache[stripe].get(idx);
                if (s != null) {
                    String string = s;
                    return string;
                }
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
        }
        s = (String)super.valueOf(idx);
        if (stripe != -1 && s != null) {
            this.myStripeLocks[stripe].lock();
            try {
                this.myIdToStringCache[stripe].put(idx, s);
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
        }
        return s;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myIdToStringCache != null) {
            for (int i = 0; i < this.myIdToStringCache.length; ++i) {
                this.myStripeLocks[i].lock();
                this.myIdToStringCache[i].clear();
                this.myHashcodeToIdCache[i].clear();
                this.myStripeLocks[i].unlock();
            }
        }
    }

    @Override
    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }
}

