/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import gnu.trove.TIntObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class WeakValueIntObjectHashMap<V> {
    private final TIntObjectHashMap<MyReference<V>> myMap = new TIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            this.myMap.remove(key);
            this.keyExpired(key);
        }
        return;
    }

    protected void keyExpired(int key) {
    }

    public final V get(int key) {
        MyReference ref = (MyReference)this.myMap.get(key);
        return (V)SoftReference.dereference(ref);
    }

    public final V put(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/WeakValueIntObjectHashMap", "put"));
        }
        this.processQueue();
        MyReference ref = new MyReference(key, value, this.myQueue);
        ref.name = value.toString();
        MyReference oldRef = (MyReference)this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    public final V remove(int key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    public final void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    public final int size() {
        return this.myMap.size();
    }

    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public final boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @NotNull
    public final Collection<V> values() {
        Object[] refs;
        ArrayList result = new ArrayList();
        for (Object o : refs = this.myMap.getValues()) {
            Object value = ((MyReference)o).get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakValueIntObjectHashMap", "values"));
        }
        return arrayList;
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int key;
        String name;

        private MyReference(int key, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

