/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NotNull;

public final class SoftValueHashMap<K, V>
extends RefValueHashMap<K, V> {
    public SoftValueHashMap() {
    }

    public SoftValueHashMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/SoftValueHashMap", "<init>"));
        }
        super(strategy);
    }

    @Override
    protected RefValueHashMap.MyReference<K, V> createReference(@NotNull K key, V value, @NotNull ReferenceQueue<V> queue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/SoftValueHashMap", "createReference"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/SoftValueHashMap", "createReference"));
        }
        return new MySoftReference<K, V>(key, value, queue);
    }

    private static class MySoftReference<K, T>
    extends SoftReference<T>
    implements RefValueHashMap.MyReference<K, T> {
        private final K key;

        public MySoftReference(@NotNull K key, T referent, @NotNull ReferenceQueue<? super T> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/SoftValueHashMap$MySoftReference", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/SoftValueHashMap$MySoftReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }
}

