/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ReflectionUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class FilteringIterator<Dom, E extends Dom>
implements Iterator<E> {
    private final Iterator<Dom> myBaseIterator;
    private final Condition<Dom> myFilter;
    private boolean myNextObtained;
    private boolean myCurrentIsValid;
    private Dom myCurrent;
    private Boolean myCurrentPassedFilter;
    public static final Condition NOT_NULL = new Condition(){

        public boolean value(Object t) {
            return t != null;
        }
    };

    public FilteringIterator(@NotNull Iterator<Dom> baseIterator, @NotNull Condition<Dom> filter) {
        if (baseIterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/FilteringIterator", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/FilteringIterator", "<init>"));
        }
        this.myNextObtained = false;
        this.myCurrentIsValid = false;
        this.myCurrentPassedFilter = null;
        this.myBaseIterator = baseIterator;
        this.myFilter = filter;
    }

    private void obtainNext() {
        if (this.myNextObtained) {
            return;
        }
        boolean hasNext = this.myBaseIterator.hasNext();
        this.setCurrent(hasNext ? (Dom)this.myBaseIterator.next() : null);
        this.myCurrentIsValid = hasNext;
        this.myNextObtained = true;
    }

    @Override
    public boolean hasNext() {
        this.obtainNext();
        if (!this.myCurrentIsValid) {
            return false;
        }
        boolean value = this.isCurrentPassesFilter();
        while (!value && this.myBaseIterator.hasNext()) {
            Dom next = this.myBaseIterator.next();
            this.setCurrent(next);
            value = this.isCurrentPassesFilter();
        }
        return value;
    }

    private void setCurrent(Dom next) {
        this.myCurrent = next;
        this.myCurrentPassedFilter = null;
    }

    private boolean isCurrentPassesFilter() {
        if (this.myCurrentPassedFilter != null) {
            return this.myCurrentPassedFilter;
        }
        boolean passed = this.myFilter.value(this.myCurrent);
        this.myCurrentPassedFilter = passed;
        return passed;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Dom result = this.myCurrent;
        this.myNextObtained = false;
        return (E)result;
    }

    @Override
    public void remove() {
        if (this.myNextObtained) {
            throw new IllegalStateException();
        }
        this.myBaseIterator.remove();
    }

    public static <T> Iterator<T> skipNulls(Iterator<T> iterator) {
        return FilteringIterator.create(iterator, NOT_NULL);
    }

    public static <Dom, T extends Dom> Iterator<T> create(Iterator<Dom> iterator, Condition<Dom> condition) {
        return new FilteringIterator(iterator, condition);
    }

    public static <T> Condition<T> alwaysTrueCondition(Class<T> aClass) {
        return Conditions.alwaysTrue();
    }

    public static <T> InstanceOf<T> instanceOf(Class<T> aClass) {
        return new InstanceOf<T>(aClass);
    }

    public static <T> Iterator<T> createInstanceOf(Iterator<?> iterator, Class<T> aClass) {
        return FilteringIterator.create(iterator, FilteringIterator.instanceOf(aClass));
    }

    public static class InstanceOf<T>
    implements Condition {
        private final Class<T> myInstancesClass;

        public InstanceOf(Class<T> instancesClass) {
            this.myInstancesClass = instancesClass;
        }

        public boolean value(Object object) {
            return this.myInstancesClass.isInstance(object);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return ReflectionUtil.isAssignable(this.myInstancesClass, hintClass);
        }

        public T cast(Object object) {
            return (T)object;
        }
    }
}

