/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueIntObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

public class ConcurrentSoftValueIntObjectHashMap<V>
extends ConcurrentRefValueIntObjectHashMap<V> {
    @Override
    protected ConcurrentRefValueIntObjectHashMap.IntReference<V> createReference(int key, @NotNull V value, ReferenceQueue<V> queue) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap", "createReference"));
        }
        return new MyRef<V>(key, value, queue);
    }

    private static class MyRef<V>
    extends SoftReference<V>
    implements ConcurrentRefValueIntObjectHashMap.IntReference<V> {
        private final int hash;
        private final int key;

        MyRef(int key, @NotNull V referent, ReferenceQueue<V> queue) {
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap$MyRef", "<init>"));
            }
            super(referent, queue);
            this.key = key;
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Object v = this.get();
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef other = (MyRef)obj;
            return other.hash == this.hash && this.key == other.getKey() && Comparing.equal(v, other.get());
        }

        @Override
        public int getKey() {
            return this.key;
        }
    }
}

