/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentSoftValueHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentSoftValueHashMap", "<init>"));
        }
        super(map);
    }

    public ConcurrentSoftValueHashMap() {
    }

    public ConcurrentSoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentSoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/containers/ConcurrentSoftValueHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    protected ConcurrentRefValueHashMap.MyValueReference<K, V> createRef(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentSoftValueHashMap", "createRef"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentSoftValueHashMap", "createRef"));
        }
        return new MySoftReference(key, value, this.myQueue);
    }

    private static class MySoftReference<K, T>
    extends SoftReference<T>
    implements ConcurrentRefValueHashMap.MyValueReference<K, T> {
        private final K key;

        private MySoftReference(@NotNull K key, @NotNull T referent, @NotNull ReferenceQueue<T> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "getKey"));
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.MyValueReference that = (ConcurrentRefValueHashMap.MyValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

