/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Restarter {
    private Restarter() {
    }

    private static int getRestartCode() {
        String s = System.getProperty("jb.restart.code");
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static boolean isSupported() {
        return Restarter.getRestartCode() != 0 || SystemInfo.isWindows || SystemInfo.isMac;
    }

    public static int scheduleRestart(String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/Restarter", "scheduleRestart"));
        }
        try {
            int restartCode = Restarter.getRestartCode();
            if (restartCode != 0) {
                Restarter.runCommand(beforeRestart);
                return restartCode;
            }
            if (SystemInfo.isWindows) {
                Restarter.restartOnWindows(beforeRestart);
                return 0;
            }
            if (SystemInfo.isMac) {
                Restarter.restartOnMac(beforeRestart);
                return 0;
            }
        }
        catch (Throwable t) {
            throw new IOException("Cannot restart application: " + t.getMessage(), t);
        }
        Restarter.runCommand(beforeRestart);
        throw new IOException("Cannot restart application: not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommand(String ... beforeRestart) throws IOException {
        if (beforeRestart.length == 0) {
            return;
        }
        try {
            Process process = Runtime.getRuntime().exec(beforeRestart);
            Thread outThread = new Thread(new StreamRedirector(process.getInputStream(), System.out));
            Thread errThread = new Thread(new StreamRedirector(process.getErrorStream(), System.err));
            outThread.start();
            errThread.start();
            try {
                process.waitFor();
            }
            finally {
                outThread.join();
                errThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void restartOnWindows(final String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/Restarter", "restartOnWindows"));
        }
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
        Shell32 shell32 = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class);
        final int pid = kernel32.GetCurrentProcessId();
        final IntByReference argc = new IntByReference();
        Pointer argv_ptr = shell32.CommandLineToArgvW(kernel32.GetCommandLineW(), argc);
        final String[] argv = argv_ptr.getStringArray(0L, argc.getValue(), true);
        kernel32.LocalFree(argv_ptr);
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restarter.exe"), new Consumer<List<String>>(){

            @Override
            public void consume(List<String> commands) {
                Collections.addAll(commands, String.valueOf(pid), String.valueOf(beforeRestart.length));
                Collections.addAll(commands, beforeRestart);
                Collections.addAll(commands, String.valueOf(argc.getValue()));
                Collections.addAll(commands, argv);
            }
        });
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    private static void restartOnMac(final String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/Restarter", "restartOnMac"));
        }
        final String homePath = PathManager.getHomePath().substring(0, PathManager.getHomePath().indexOf(".app") + 4);
        if (!StringUtil.endsWithIgnoreCase(homePath, ".app")) {
            throw new IOException("Application bundle not found: " + homePath);
        }
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restarter"), new Consumer<List<String>>(){

            @Override
            public void consume(List<String> commands) {
                Collections.addAll(commands, homePath);
                Collections.addAll(commands, beforeRestart);
            }
        });
    }

    private static void doScheduleRestart(File restarterFile, Consumer<List<String>> argumentsBuilder) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(Restarter.createTempExecutable(restarterFile).getPath());
        argumentsBuilder.consume(commands);
        Runtime.getRuntime().exec(commands.toArray(new String[commands.size()]));
    }

    public static File createTempExecutable(File executable) throws IOException {
        String ext = FileUtilRt.getExtension(executable.getName());
        File copy = FileUtilRt.createTempFile(FileUtilRt.getNameWithoutExtension(executable.getName()), StringUtil.isEmptyOrSpaces(ext) ? ".tmp" : "." + ext, false);
        FileUtilRt.copy(executable, copy);
        if (!copy.setExecutable(executable.canExecute())) {
            throw new IOException("Cannot make file executable: " + copy);
        }
        return copy;
    }

    private static class StreamRedirector
    implements Runnable {
        private final InputStream myIn;
        private final OutputStream myOut;

        private StreamRedirector(InputStream in, OutputStream out) {
            this.myIn = in;
            this.myOut = out;
        }

        @Override
        public void run() {
            try {
                StreamUtil.copyStreamContent(this.myIn, this.myOut);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static interface Shell32
    extends StdCallLibrary {
        public Pointer CommandLineToArgvW(WString var1, IntByReference var2);
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public int GetCurrentProcessId();

        public WString GetCommandLineW();

        public Pointer LocalFree(Pointer var1);
    }
}

