/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Key;
import com.intellij.util.SharedProcessingContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProcessingContext {
    private Map<Object, Object> myMap;
    private SharedProcessingContext mySharedContext;

    public ProcessingContext() {
    }

    public ProcessingContext(SharedProcessingContext sharedContext) {
        this.mySharedContext = sharedContext;
    }

    @NotNull
    public SharedProcessingContext getSharedContext() {
        if (this.mySharedContext == null) {
            this.mySharedContext = new SharedProcessingContext();
            if (this.mySharedContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ProcessingContext", "getSharedContext"));
            }
            return this.mySharedContext;
        }
        SharedProcessingContext sharedProcessingContext = this.mySharedContext;
        if (sharedProcessingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ProcessingContext", "getSharedContext"));
        }
        return sharedProcessingContext;
    }

    public Object get(@NotNull @NonNls Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ProcessingContext", "get"));
        }
        return this.myMap == null ? null : this.myMap.get(key);
    }

    public void put(@NotNull @NonNls Object key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ProcessingContext", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ProcessingContext", "put"));
        }
        this.checkMapInitialized();
        this.myMap.put(key, value);
    }

    public <T> void put(Key<T> key, T value) {
        this.checkMapInitialized();
        this.myMap.put(key, value);
    }

    public <T> T get(Key<T> key) {
        return (T)(this.myMap == null ? null : this.myMap.get(key));
    }

    private void checkMapInitialized() {
        if (this.myMap == null) {
            this.myMap = new HashMap<Object, Object>(1);
        }
    }
}

