/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PatternUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PatternUtil");
    private static final HashMap<String, String> ourEscapeRules = new HashMap();

    private static void escape2(char symbol) {
        ourEscapeRules.put(String.valueOf(symbol), "\\" + symbol);
    }

    public static String convertToRegex(String mask) {
        List<String> strings = StringUtil.split(mask, "\\");
        StringBuilder pattern = new StringBuilder();
        String separator = "";
        for (String string : strings) {
            string = StringUtil.replace(string, ".", "\\.");
            for (Map.Entry e : ourEscapeRules.entrySet()) {
                string = StringUtil.replace(string, (String)e.getKey(), (String)e.getValue());
            }
            pattern.append(separator);
            separator = "\\\\";
            pattern.append(string);
        }
        return pattern.toString();
    }

    public static Pattern fromMask(@NonNls String mask) {
        try {
            return Pattern.compile(PatternUtil.convertToRegex(mask));
        }
        catch (PatternSyntaxException e) {
            LOG.error(mask, e);
            return Pattern.compile("");
        }
    }

    @Nullable
    public static String getFirstMatch(List<String> lines, Pattern regex) {
        if (lines == null) {
            return null;
        }
        for (String s : lines) {
            Matcher m = regex.matcher(s);
            if (!m.matches() || m.groupCount() <= 0) continue;
            return m.group(1);
        }
        return null;
    }

    static {
        ourEscapeRules.put("*", ".*");
        ourEscapeRules.put("?", ".");
        PatternUtil.escape2('+');
        PatternUtil.escape2('(');
        PatternUtil.escape2(')');
        PatternUtil.escape2('[');
        PatternUtil.escape2(']');
        PatternUtil.escape2('/');
        PatternUtil.escape2('^');
        PatternUtil.escape2('$');
        PatternUtil.escape2('{');
        PatternUtil.escape2('}');
        PatternUtil.escape2('|');
    }
}

