/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "invokeAll"));
        }
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future = executorService.submit(callable);
                futures.add(future);
            }
            for (Future future : futures) {
                ((Runnable)((Object)future)).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        Object v = map.get(key);
        if (v != null) {
            Object v2 = v;
            if (v2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
            }
            return v2;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        return v3;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String threadFactoryName) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor(threadFactoryName, 5);
        if (threadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String threadFactoryName, int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(threadFactoryName, true, threadPriority));
        if (threadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NotNull @NonNls String threadFactoryName) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor(threadFactoryName, 5);
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String threadFactoryName, int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(threadFactoryName, true, threadPriority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String threadName, final boolean isDaemon, final int threadPriority) {
        if (threadName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil$1", "newThread"));
                }
                Thread thread = new Thread(r, threadName);
                thread.setDaemon(isDaemon);
                thread.setPriority(threadPriority);
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil$1", "newThread"));
                }
                return thread2;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        return threadFactory;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String threadName) {
        if (threadName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil$2", "newThread"));
                }
                Thread thread = new Thread(r, threadName);
                if (thread == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil$2", "newThread"));
                }
                return thread;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        return threadFactory;
    }
}

