/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.mac.foundation.MacUtil");
    public static final String MAC_NATIVE_WINDOW_SHOWING = "MAC_NATIVE_WINDOW_SHOWING";

    private MacUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ID findWindowForTitle(String title) {
        ID focusedWindow;
        block5: {
            if (title == null || title.isEmpty()) {
                return null;
            }
            ID pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
            focusedWindow = null;
            try {
                String titleString;
                ID window;
                ID windowTitle;
                ID sharedApplication = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                ID windows = Foundation.invoke(sharedApplication, "windows", new Object[0]);
                ID windowEnumerator = Foundation.invoke(windows, "objectEnumerator", new Object[0]);
                do {
                    if (0 != (window = Foundation.invoke(windowEnumerator, "nextObject", new Object[0])).intValue()) continue;
                    break block5;
                } while ((windowTitle = Foundation.invoke(window, "title", new Object[0])) == null || windowTitle.intValue() == 0 || !Comparing.equal(titleString = Foundation.toStringViaUTF8(windowTitle), title));
                focusedWindow = window;
            }
            finally {
                Foundation.invoke(pool, "release", new Object[0]);
            }
        }
        return focusedWindow;
    }

    public static synchronized void startModal(JComponent component, String key) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = component.getToolkit().getSystemEventQueue();
                while (component.getClientProperty(key) == Boolean.TRUE) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    LOG.debug("Unable to dispatch: " + event);
                }
            } else {
                assert (false) : "Should be called from Event-Dispatch Thread only!";
                while (component.getClientProperty(key) == Boolean.TRUE) {
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static synchronized void startModal(JComponent component) {
        MacUtil.startModal(component, MAC_NATIVE_WINDOW_SHOWING);
    }

    public static boolean isFullKeyboardAccessEnabled() {
        if (!SystemInfo.isMacOSSnowLeopard) {
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean();
        Foundation.executeOnMainThread(new Runnable(){

            @Override
            public void run() {
                result.set(Foundation.invoke(Foundation.invoke("NSApplication", "sharedApplication", new Object[0]), "isFullKeyboardAccessEnabled", new Object[0]).intValue() == 1);
            }
        }, true, true);
        return result.get();
    }

    public static void adjustFocusTraversal(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/foundation/MacUtil", "adjustFocusTraversal"));
        }
        if (!SystemInfo.isMacOSSnowLeopard) {
            return;
        }
        final AWTEventListener listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof KeyEvent && ((KeyEvent)event).getKeyCode() == 9 && !(event.getSource() instanceof JTextComponent) && !(event.getSource() instanceof JList) && !MacUtil.isFullKeyboardAccessEnabled()) {
                    ((KeyEvent)event).consume();
                }
            }
        };
        Disposer.register(disposable, new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 8L);
    }

    public static ID findWindowFromJavaWindow(Window w) {
        ID windowId = null;
        if (SystemInfo.isJavaVersionAtLeast("1.7") && Registry.is("skip.untitled.windows.for.mac.messages")) {
            try {
                Class<?> cWindowPeerClass = w.getPeer().getClass();
                Method getPlatformWindowMethod = cWindowPeerClass.getDeclaredMethod("getPlatformWindow", new Class[0]);
                Object cPlatformWindow = getPlatformWindowMethod.invoke((Object)w.getPeer(), new Object[0]);
                Class<?> cPlatformWindowClass = cPlatformWindow.getClass();
                Method getNSWindowPtrMethod = cPlatformWindowClass.getDeclaredMethod("getNSWindowPtr", new Class[0]);
                windowId = new ID((Long)getNSWindowPtrMethod.invoke(cPlatformWindow, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                LOG.debug(e);
            }
            catch (InvocationTargetException e) {
                LOG.debug(e);
            }
            catch (IllegalAccessException e) {
                LOG.debug(e);
            }
        } else {
            String foremostWindowTitle = MacUtil.getWindowTitle(w);
            windowId = MacUtil.findWindowForTitle(foremostWindowTitle);
        }
        return windowId;
    }

    public static String getWindowTitle(Window documentRoot) {
        String windowTitle;
        if (documentRoot instanceof Frame) {
            windowTitle = ((Frame)documentRoot).getTitle();
        } else if (documentRoot instanceof Dialog) {
            windowTitle = ((Dialog)documentRoot).getTitle();
        } else {
            throw new RuntimeException("The window is not a frame and not a dialog!");
        }
        return windowTitle;
    }
}

