/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.Equality;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private long myModification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "getNode"));
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myObject2NodeMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "putNode"));
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return node == null ? this.myObject2NodeMap.remove(object) : this.myObject2NodeMap.put(object, node);
        }
    }

    public final List<ObjectNode<T>> getNodesInExecution() {
        return this.myExecutedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent, @NotNull T child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectTree", "register"));
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> parentNode = this.getOrCreateNodeFor(parent, null);
            ObjectNode<T> childNode = this.getNode(child);
            if (childNode == null) {
                childNode = this.createNodeFor(child, parentNode, Disposer.isDebugMode() ? new Throwable() : null);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(childNode, child);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    private void checkWasNotAddedAlready(@NotNull ObjectNode<T> childNode, @NotNull T child) {
        boolean childIsInTree;
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "checkWasNotAddedAlready"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectTree", "checkWasNotAddedAlready"));
        }
        ObjectNode<T> parent = childNode.getParent();
        boolean bl = childIsInTree = parent != null;
        if (!childIsInTree) {
            return;
        }
        while (parent != null) {
            if (parent.getObject() == child) {
                LOG.error(child + " was already added as a child of: " + parent);
            }
            parent = parent.getParent();
        }
    }

    @NotNull
    private ObjectNode<T> getOrCreateNodeFor(@NotNull T object, @Nullable ObjectNode<T> defaultParent) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "getOrCreateNodeFor"));
        }
        ObjectNode<T> node = this.getNode(object);
        if (node != null) {
            ObjectNode<T> objectNode = node;
            if (objectNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "getOrCreateNodeFor"));
            }
            return objectNode;
        }
        ObjectNode<T> objectNode = this.createNodeFor(object, defaultParent, Disposer.isDebugMode() ? new Throwable() : null);
        if (objectNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "getOrCreateNodeFor"));
        }
        return objectNode;
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode, @Nullable Throwable trace) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "createNodeFor"));
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification(), trace);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "createNodeFor"));
        }
        return objectNode;
    }

    public long getNextModification() {
        return ++this.myModification;
    }

    public final boolean executeAll(@NotNull T object, boolean disposeTree, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "executeAll"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/util/objectTree/ObjectTree", "executeAll"));
        }
        ObjectNode<T> node = this.getNode(object);
        if (node == null) {
            if (processUnregistered) {
                this.executeUnregistered(object, action);
                return true;
            }
            return false;
        }
        node.execute(disposeTree, action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        if (recursiveGuard == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY);
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "executeUnregistered"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectTree", "executeUnregistered"));
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeChildAndReplace(@NotNull T toExecute, @NotNull T toReplace, boolean disposeTree, @NotNull ObjectTreeAction<T> action) {
        T parentObject;
        if (toExecute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "executeChildAndReplace"));
        }
        if (toReplace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectTree", "executeChildAndReplace"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/util/objectTree/ObjectTree", "executeChildAndReplace"));
        }
        ObjectNode<T> toExecuteNode = this.getNode(toExecute);
        assert (toExecuteNode != null) : "Object " + toExecute + " wasn't registered or already disposed";
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> parent = toExecuteNode.getParent();
            assert (parent != null) : "Object " + toExecute + " is not connected to the tree - doesn't have parent";
            parentObject = parent.getObject();
        }
        toExecuteNode.execute(disposeTree, action);
        this.register(parentObject, toReplace);
    }

    public boolean containsKey(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "containsKey"));
        }
        return this.getNode(object) != null;
    }

    public void assertNoReferenceKeptInTree(@NotNull T disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "assertNoReferenceKeptInTree"));
        }
        Collection<ObjectNode<T>> nodes = this.myObject2NodeMap.values();
        for (ObjectNode<T> node : nodes) {
            node.assertNoReferencesKept(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootObject(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "removeRootObject"));
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            this.myRootObjects.remove(object);
        }
    }

    public void assertIsEmpty(boolean throwError) {
        for (T object : this.myRootObjects) {
            ObjectNode<T> objectNode;
            if (object == null || (objectNode = this.getNode(object)) == null) continue;
            Throwable trace = objectNode.getTrace();
            RuntimeException exception = new RuntimeException("Memory leak detected: " + object + " of class " + object.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
            if (throwError) {
                throw exception;
            }
            LOG.error(exception);
        }
    }

    public boolean isEmpty() {
        return this.myRootObjects.isEmpty();
    }

    public void clearAll() {
        this.myRootObjects.clear();
        this.myExecutedNodes.clear();
        this.myExecutedUnregisteredNodes.clear();
        this.myObject2NodeMap.clear();
    }

    @NotNull
    public Set<T> getRootObjects() {
        Set<T> set = this.myRootObjects;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "getRootObjects"));
        }
        return set;
    }

    public void addListener(@NotNull ObjectTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull ObjectTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    void fireRegistered(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "fireRegistered"));
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "fireExecuted"));
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
    }

    public int size() {
        return this.myObject2NodeMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <D extends Disposable> D findRegisteredObject(@NotNull T parentDisposable, @NotNull D object) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectTree", "findRegisteredObject"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectTree", "findRegisteredObject"));
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode<T> parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }

    public long getModification() {
        return this.myModification;
    }
}

