/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;

public class JarUtil {
    public static boolean containsClass(@NotNull String jarPath, @NotNull String className) {
        if (jarPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/io/JarUtil", "containsClass"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/io/JarUtil", "containsClass"));
        }
        return JarUtil.containsClass(new File(jarPath), className);
    }

    public static boolean containsClass(@NotNull File file, String className) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/io/JarUtil", "containsClass"));
        }
        String entryPath = className.replace('.', '/') + ".class";
        return JarUtil.containsEntry(file, entryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsEntry(File file, String entryPath) {
        if (file.canRead()) {
            boolean bl;
            JarFile jarFile = new JarFile(file);
            try {
                bl = jarFile.getEntry(entryPath) != null;
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            jarFile.close();
            return bl;
        }
        return false;
    }
}

