/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffString
implements CharSequence {
    @NotNull
    public static final DiffString EMPTY = new DiffString(new char[0], 0, 0);
    @NotNull
    private final char[] myData;
    private final int myStart;
    private final int myLength;
    private int myHash;

    @Nullable
    public static DiffString createNullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return DiffString.create(string);
    }

    @NotNull
    public static DiffString create(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        if (string.isEmpty()) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
            }
            return diffString;
        }
        DiffString diffString = DiffString.create(string.toCharArray());
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        return diffString;
    }

    @NotNull
    static DiffString create(@NotNull char[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        DiffString diffString = DiffString.create(data, 0, data.length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        return diffString;
    }

    @NotNull
    static DiffString create(@NotNull char[] data, int start, int length) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        if (length == 0) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
            }
            return diffString;
        }
        DiffString.checkBounds(start, length, data.length);
        DiffString diffString = new DiffString(data, start, length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        return diffString;
    }

    private DiffString(@NotNull char[] data, int start, int length) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "<init>"));
        }
        this.myData = data;
        this.myStart = start;
        this.myLength = length;
    }

    @Override
    public int length() {
        return this.myLength;
    }

    @Override
    public boolean isEmpty() {
        return this.myLength == 0;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.myLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.data(index);
    }

    public char data(int index) {
        return this.myData[this.myStart + index];
    }

    @NotNull
    public DiffString substring(int start) {
        DiffString diffString = this.substring(start, this.myLength);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "substring"));
        }
        return diffString;
    }

    @NotNull
    public DiffString substring(int start, int end) {
        if (start == 0 && end == this.myLength) {
            DiffString diffString = this;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "substring"));
            }
            return diffString;
        }
        DiffString.checkBounds(start, end - start, this.myLength);
        DiffString diffString = DiffString.create(this.myData, this.myStart + start, end - start);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "substring"));
        }
        return diffString;
    }

    @Override
    public DiffString subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    @NotNull
    public String toString() {
        String string = new String(this.myData, this.myStart, this.myLength);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "toString"));
        }
        return string;
    }

    @NotNull
    public DiffString copy() {
        DiffString diffString = DiffString.create(Arrays.copyOfRange(this.myData, this.myStart, this.myStart + this.myLength));
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "copy"));
        }
        return diffString;
    }

    public void copyData(@NotNull char[] dst, int start) {
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "copyData"));
        }
        DiffString.checkBounds(start, this.myLength, dst.length);
        System.arraycopy(this.myData, this.myStart, dst, start, this.myLength);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffString that = (DiffString)o;
        if (this.myLength != that.myLength) {
            return false;
        }
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.myLength; ++i) {
            if (this.data(i) == that.data(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.myHash;
        if (h == 0) {
            h = StringUtil.stringHashCode(this.myData, this.myStart, this.myStart + this.myLength);
            if (h == 0) {
                h = 1;
            }
            this.myHash = h;
        }
        return h;
    }

    @Nullable
    public static DiffString concatenateNullable(@Nullable DiffString s1, @Nullable DiffString s2) {
        if (s1 == null || s2 == null) {
            if (s1 != null) {
                return s1;
            }
            if (s2 != null) {
                return s2;
            }
            return null;
        }
        return DiffString.concatenate(s1, s2);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s1.isEmpty()) {
            DiffString diffString = s2;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        if (s2.isEmpty()) {
            DiffString diffString = s1;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        if (s1.myData == s2.myData && s1.myStart + s1.myLength == s2.myStart) {
            DiffString diffString = DiffString.create(s1.myData, s1.myStart, s1.myLength + s2.myLength);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        char[] data = new char[s1.myLength + s2.myLength];
        System.arraycopy(s1.myData, s1.myStart, data, 0, s1.myLength);
        System.arraycopy(s2.myData, s2.myStart, data, s1.myLength, s2.myLength);
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    public static boolean canInplaceConcatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "canInplaceConcatenate"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/string/DiffString", "canInplaceConcatenate"));
        }
        if (s1.isEmpty()) {
            return true;
        }
        if (s2.isEmpty()) {
            return true;
        }
        return s1.myData == s2.myData && s1.myStart + s1.myLength == s2.myStart;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        DiffString diffString = DiffString.concatenateCopying(strings, 0, strings.length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings, int start, int length) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        DiffString.checkBounds(start, length, strings.length);
        int len = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            len += string == null ? 0 : string.myLength;
        }
        if (len == 0) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
            }
            return diffString;
        }
        char[] data = new char[len];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            System.arraycopy(string.myData, string.myStart, data, index, string.myLength);
            index += string.myLength;
        }
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s.myStart + s.myLength < s.myData.length && s.data(s.myLength) == c) {
            DiffString diffString = DiffString.create(s.myData, s.myStart, s.myLength + 1);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        char[] data = new char[s.myLength + 1];
        System.arraycopy(s.myData, s.myStart, data, 0, s.myLength);
        data[s.myLength] = c;
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(char c, @NotNull DiffString s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s.myStart > 0 && s.data(-1) == c) {
            DiffString diffString = DiffString.create(s.myData, s.myStart - 1, s.myLength + 1);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        char[] data = new char[s.myLength + 1];
        System.arraycopy(s.myData, s.myStart, data, 1, s.myLength);
        data[0] = c;
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        DiffString diffString = DiffString.concatenate(strings, 0, strings.length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings, int start, int length) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        DiffString.checkBounds(start, length, strings.length);
        char[] data = null;
        int startIndex = 0;
        int endIndex = 0;
        boolean linearized = true;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            if (data == null) {
                data = string.myData;
                startIndex = string.myStart;
                endIndex = string.myStart + string.myLength;
                continue;
            }
            if (data != string.myData || string.myStart != endIndex) {
                linearized = false;
                break;
            }
            endIndex += string.myLength;
        }
        if (linearized) {
            if (data == null) {
                DiffString diffString = EMPTY;
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
                }
                return diffString;
            }
            DiffString diffString = DiffString.create(data, startIndex, endIndex - startIndex);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        DiffString diffString = DiffString.concatenateCopying(strings, start, length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public DiffString append(char c) {
        DiffString diffString = DiffString.concatenate(this, c);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "append"));
        }
        return diffString;
    }

    @NotNull
    public DiffString preappend(char c) {
        DiffString diffString = DiffString.concatenate(c, this);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "preappend"));
        }
        return diffString;
    }

    public static boolean isWhiteSpace(char c) {
        return StringUtil.isWhiteSpace(c);
    }

    public boolean isEmptyOrSpaces() {
        if (this.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.myLength; ++i) {
            if (DiffString.isWhiteSpace(this.data(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public DiffString trim() {
        int start;
        int end = this.myLength;
        for (start = 0; start < end && DiffString.isWhiteSpace(this.data(start)); ++start) {
        }
        while (end > start && DiffString.isWhiteSpace(this.data(end - 1))) {
            --end;
        }
        DiffString diffString = this.substring(start, end);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "trim"));
        }
        return diffString;
    }

    @NotNull
    public DiffString trimLeading() {
        int i;
        for (i = 0; i < this.myLength && DiffString.isWhiteSpace(this.data(i)); ++i) {
        }
        DiffString diffString = this.substring(i, this.myLength);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "trimLeading"));
        }
        return diffString;
    }

    @NotNull
    public DiffString trimTrailing() {
        int end;
        for (end = this.myLength; end > 0 && DiffString.isWhiteSpace(this.data(end - 1)); --end) {
        }
        DiffString diffString = this.substring(0, end);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "trimTrailing"));
        }
        return diffString;
    }

    @NotNull
    public DiffString getLeadingSpaces() {
        int i;
        for (i = 0; i < this.myLength && this.data(i) == ' '; ++i) {
        }
        DiffString diffString = this.substring(0, i);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "getLeadingSpaces"));
        }
        return diffString;
    }

    @NotNull
    public DiffString skipSpaces() {
        DiffString s = this.trim();
        int count = 0;
        for (int i = 0; i < s.myLength; ++i) {
            if (!DiffString.isWhiteSpace(s.data(i))) continue;
            ++count;
        }
        if (count == 0) {
            DiffString diffString = s;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "skipSpaces"));
            }
            return diffString;
        }
        char[] data = new char[s.myLength - count];
        int index = 0;
        for (int i = 0; i < s.myLength; ++i) {
            if (DiffString.isWhiteSpace(s.data(i))) continue;
            data[index] = s.data(i);
            ++index;
        }
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "skipSpaces"));
        }
        return diffString;
    }

    public int indexOf(char c) {
        return StringUtil.indexOf((CharSequence)this, c);
    }

    public boolean endsWith(char c) {
        if (this.isEmpty()) {
            return false;
        }
        return this.data(this.myLength - 1) == c;
    }

    public static void checkBounds(int start, int length, int maxLength) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (start + length > maxLength) {
            throw new StringIndexOutOfBoundsException(start + length);
        }
    }

    @NotNull
    public DiffString[] tokenize() {
        DiffString[] diffStringArray = new LineTokenizer(this).execute();
        if (diffStringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "tokenize"));
        }
        return diffStringArray;
    }

    public static class LineTokenizer
    extends LineTokenizerBase<DiffString> {
        @NotNull
        private final DiffString myText;

        public LineTokenizer(@NotNull DiffString text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer", "<init>"));
            }
            this.myText = text;
        }

        @NotNull
        public DiffString[] execute() {
            ArrayList lines = new ArrayList();
            this.doExecute(lines);
            DiffString[] diffStringArray = ContainerUtil.toArray(lines, new DiffString[lines.size()]);
            if (diffStringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer", "execute"));
            }
            return diffStringArray;
        }

        @Override
        protected void addLine(List<DiffString> lines, int start, int end, boolean appendNewLine) {
            if (appendNewLine) {
                lines.add(this.myText.substring(start, end).append('\n'));
            } else {
                lines.add(this.myText.substring(start, end));
            }
        }

        @Override
        protected char charAt(int index) {
            return this.myText.data(index);
        }

        @Override
        protected int length() {
            return this.myText.length();
        }

        @Override
        @NotNull
        protected String substring(int start, int end) {
            String string = this.myText.substring(start, end).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer", "substring"));
            }
            return string;
        }
    }
}

