/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class Word {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.Word");
    @NotNull
    private final DiffString myBaseText;
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final DiffString myText;

    public Word(@NotNull String baseText, @NotNull TextRange range) {
        if (baseText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/processing/Word", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/processing/Word", "<init>"));
        }
        this(DiffString.create(baseText), range);
    }

    public Word(@NotNull DiffString baseText, @NotNull TextRange range) {
        if (baseText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/processing/Word", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/processing/Word", "<init>"));
        }
        this.myBaseText = baseText;
        this.myRange = range;
        this.myText = this.myBaseText.substring(this.myRange.getStartOffset(), this.myRange.getEndOffset());
        LOG.assertTrue(this.myRange.getStartOffset() >= 0);
        LOG.assertTrue(this.myRange.getEndOffset() >= this.myRange.getStartOffset(), this.myRange);
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Word)) {
            return false;
        }
        Word other = (Word)obj;
        return this.getText().equals(other.getText());
    }

    @NotNull
    public DiffString getText() {
        DiffString diffString = this.myText;
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/Word", "getText"));
        }
        return diffString;
    }

    @NotNull
    public DiffString getPrefix(int fromPosition) {
        LOG.assertTrue(fromPosition >= 0, fromPosition);
        int wordStart = this.myRange.getStartOffset();
        LOG.assertTrue(fromPosition <= wordStart, fromPosition + " " + wordStart);
        DiffString diffString = this.myBaseText.substring(fromPosition, wordStart);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/Word", "getPrefix"));
        }
        return diffString;
    }

    public int getEnd() {
        return this.myRange.getEndOffset();
    }

    public int getStart() {
        return this.myRange.getStartOffset();
    }

    public String toString() {
        return this.myText.toString();
    }

    public boolean isWhitespace() {
        return false;
    }

    public boolean atEndOfLine() {
        int start = this.myRange.getStartOffset();
        if (start == 0) {
            return true;
        }
        if (this.myBaseText.charAt(start - 1) == '\n') {
            return true;
        }
        int end = this.myRange.getEndOffset();
        if (end == this.myBaseText.length()) {
            return true;
        }
        return this.myBaseText.charAt(end) == '\n';
    }
}

