/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslSocketFactory
extends SSLSocketFactory {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    private SSLSocketFactory myFactory;

    public SslSocketFactory() throws GeneralSecurityException, IOException {
        MyX509TrustManager tm;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            tm = new MyX509TrustManager();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(new KeyManager[0], new TrustManager[]{tm}, null);
        this.myFactory = ctx.getSocketFactory();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.myFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.myFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.myFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.myFactory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.myFactory.createSocket(socket, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.myFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.myFactory.getSupportedCipherSuites();
    }

    private static class MyX509TrustManager
    implements X509TrustManager {
        String serverCertFile = System.getProperty("sslCaCertPath");
        X509TrustManager trustManager;

        public MyX509TrustManager() throws Exception {
            FileInputStream inStream = new FileInputStream(this.serverCertFile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate ca = (X509Certificate)cf.generateCertificate(inStream);
            ((InputStream)inStream).close();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry(UUID.randomUUID().toString(), ca);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

